<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Settle ServiceType
 * @subpackage Services
 */
class Settle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SettleAuthorizations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SettleAuthorizations $parameters
     * @return \StructType\SettleAuthorizationsResponse|bool
     */
    public function SettleAuthorizations(\StructType\SettleAuthorizations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SettleAuthorizations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SettleAuthorization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SettleAuthorization $parameters
     * @return \StructType\SettleAuthorizationResponse|bool
     */
    public function SettleAuthorization(\StructType\SettleAuthorization $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SettleAuthorization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SettleAuthorizationResponse|\StructType\SettleAuthorizationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
