<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Merge ServiceType
 * @subpackage Services
 */
class Merge extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MergeContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MergeContacts $parameters
     * @return \StructType\MergeContactsResponse|bool
     */
    public function MergeContacts(\StructType\MergeContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MergeContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MergeContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MergeContact $parameters
     * @return \StructType\MergeContactResponse|bool
     */
    public function MergeContact(\StructType\MergeContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->MergeContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MergeContactResponse|\StructType\MergeContactsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
