<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTributes $parameters
     * @return \StructType\GetTributesResponse|bool
     */
    public function GetTributes(\StructType\GetTributes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTributeAcknowledgees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTributeAcknowledgees $parameters
     * @return \StructType\GetTributeAcknowledgeesResponse|bool
     */
    public function GetTributeAcknowledgees(\StructType\GetTributeAcknowledgees $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTributeAcknowledgees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEvents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEvents $parameters
     * @return \StructType\GetEventsResponse|bool
     */
    public function GetEvents(\StructType\GetEvents $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEvents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventRegistrations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventRegistrations $parameters
     * @return \StructType\GetEventRegistrationsResponse|bool
     */
    public function GetEventRegistrations(\StructType\GetEventRegistrations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEventRegistrations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGrassrootEvents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGrassrootEvents $parameters
     * @return \StructType\GetGrassrootEventsResponse|bool
     */
    public function GetGrassrootEvents(\StructType\GetGrassrootEvents $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGrassrootEvents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPeerToPeerPages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPeerToPeerPages $parameters
     * @return \StructType\GetPeerToPeerPagesResponse|bool
     */
    public function GetPeerToPeerPages(\StructType\GetPeerToPeerPages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPeerToPeerPages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPeerToPeerTeams
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPeerToPeerTeams $parameters
     * @return \StructType\GetPeerToPeerTeamsResponse|bool
     */
    public function GetPeerToPeerTeams(\StructType\GetPeerToPeerTeams $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPeerToPeerTeams($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPeerToPeerMicrosites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPeerToPeerMicrosites $parameters
     * @return \StructType\GetPeerToPeerMicrositesResponse|bool
     */
    public function GetPeerToPeerMicrosites(\StructType\GetPeerToPeerMicrosites $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPeerToPeerMicrosites($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebForms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebForms $parameters
     * @return \StructType\GetWebFormsResponse|bool
     */
    public function GetWebForms(\StructType\GetWebForms $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebForms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOptInLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOptInLists $parameters
     * @return \StructType\GetOptInListsResponse|bool
     */
    public function GetOptInLists(\StructType\GetOptInLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOptInLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOptInListContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOptInListContacts $parameters
     * @return \StructType\GetOptInListContactsResponse|bool
     */
    public function GetOptInListContacts(\StructType\GetOptInListContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOptInListContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiatives
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiatives $parameters
     * @return \StructType\GetInitiativesResponse|bool
     */
    public function GetInitiatives(\StructType\GetInitiatives $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiatives($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeMessages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeMessages $parameters
     * @return \StructType\GetInitiativeMessagesResponse|bool
     */
    public function GetInitiativeMessages(\StructType\GetInitiativeMessages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeMessages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeAudience
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeAudience $parameters
     * @return \StructType\GetInitiativeAudienceResponse|bool
     */
    public function GetInitiativeAudience(\StructType\GetInitiativeAudience $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeAudience($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeDeliveryFailures
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeDeliveryFailures $parameters
     * @return \StructType\GetInitiativeDeliveryFailuresResponse|bool
     */
    public function GetInitiativeDeliveryFailures(\StructType\GetInitiativeDeliveryFailures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeDeliveryFailures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeMessageReturns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeMessageReturns $parameters
     * @return \StructType\GetInitiativeMessageReturnsResponse|bool
     */
    public function GetInitiativeMessageReturns(\StructType\GetInitiativeMessageReturns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeMessageReturns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeMessageViews
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeMessageViews $parameters
     * @return \StructType\GetInitiativeMessageViewsResponse|bool
     */
    public function GetInitiativeMessageViews(\StructType\GetInitiativeMessageViews $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeMessageViews($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeClickThroughs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeClickThroughs $parameters
     * @return \StructType\GetInitiativeClickThroughsResponse|bool
     */
    public function GetInitiativeClickThroughs(\StructType\GetInitiativeClickThroughs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeClickThroughs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativePageVisits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativePageVisits $parameters
     * @return \StructType\GetInitiativePageVisitsResponse|bool
     */
    public function GetInitiativePageVisits(\StructType\GetInitiativePageVisits $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativePageVisits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInitiativeConversions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInitiativeConversions $parameters
     * @return \StructType\GetInitiativeConversionsResponse|bool
     */
    public function GetInitiativeConversions(\StructType\GetInitiativeConversions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInitiativeConversions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDoNotSolicitAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDoNotSolicitAddresses $parameters
     * @return \StructType\GetDoNotSolicitAddressesResponse|bool
     */
    public function GetDoNotSolicitAddresses(\StructType\GetDoNotSolicitAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDoNotSolicitAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDoNotSolicitEmailAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDoNotSolicitEmailAddresses $parameters
     * @return \StructType\GetDoNotSolicitEmailAddressesResponse|bool
     */
    public function GetDoNotSolicitEmailAddresses(\StructType\GetDoNotSolicitEmailAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDoNotSolicitEmailAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDoNotSolicitPhoneNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDoNotSolicitPhoneNumbers $parameters
     * @return \StructType\GetDoNotSolicitPhoneNumbersResponse|bool
     */
    public function GetDoNotSolicitPhoneNumbers(\StructType\GetDoNotSolicitPhoneNumbers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDoNotSolicitPhoneNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountries $parameters
     * @return \StructType\GetCountriesResponse|bool
     */
    public function GetCountries(\StructType\GetCountries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatesProvinces
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatesProvinces $parameters
     * @return \StructType\GetStatesProvincesResponse|bool
     */
    public function GetStatesProvinces(\StructType\GetStatesProvinces $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatesProvinces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetChangeLogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChangeLogs $parameters
     * @return \StructType\GetChangeLogsResponse|bool
     */
    public function GetChangeLogs(\StructType\GetChangeLogs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetChangeLogs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCases $parameters
     * @return \StructType\GetCasesResponse|bool
     */
    public function GetCases(\StructType\GetCases $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCases($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContacts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContacts $parameters
     * @return \StructType\GetContactsResponse|bool
     */
    public function GetContacts(\StructType\GetContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddresses $parameters
     * @return \StructType\GetAddressesResponse|bool
     */
    public function GetAddresses(\StructType\GetAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmailAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmailAddresses $parameters
     * @return \StructType\GetEmailAddressesResponse|bool
     */
    public function GetEmailAddresses(\StructType\GetEmailAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEmailAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPhoneNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneNumbers $parameters
     * @return \StructType\GetPhoneNumbersResponse|bool
     */
    public function GetPhoneNumbers(\StructType\GetPhoneNumbers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPhoneNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInstantMessengerIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInstantMessengerIds $parameters
     * @return \StructType\GetInstantMessengerIdsResponse|bool
     */
    public function GetInstantMessengerIds(\StructType\GetInstantMessengerIds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetInstantMessengerIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSocialMediaHandles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSocialMediaHandles $parameters
     * @return \StructType\GetSocialMediaHandlesResponse|bool
     */
    public function GetSocialMediaHandles(\StructType\GetSocialMediaHandles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSocialMediaHandles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebsites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebsites $parameters
     * @return \StructType\GetWebsitesResponse|bool
     */
    public function GetWebsites(\StructType\GetWebsites $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebsites($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRelationships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRelationships $parameters
     * @return \StructType\GetRelationshipsResponse|bool
     */
    public function GetRelationships(\StructType\GetRelationships $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRelationships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActivities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetActivities $parameters
     * @return \StructType\GetActivitiesResponse|bool
     */
    public function GetActivities(\StructType\GetActivities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetActivities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNotes $parameters
     * @return \StructType\GetNotesResponse|bool
     */
    public function GetNotes(\StructType\GetNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFiles $parameters
     * @return \StructType\GetFilesResponse|bool
     */
    public function GetFiles(\StructType\GetFiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroups $parameters
     * @return \StructType\GetGroupsResponse|bool
     */
    public function GetGroups(\StructType\GetGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTags
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTags $parameters
     * @return \StructType\GetTagsResponse|bool
     */
    public function GetTags(\StructType\GetTags $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTags($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpportunities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpportunities $parameters
     * @return \StructType\GetOpportunitiesResponse|bool
     */
    public function GetOpportunities(\StructType\GetOpportunities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOpportunities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContactMergeLogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContactMergeLogs $parameters
     * @return \StructType\GetContactMergeLogsResponse|bool
     */
    public function GetContactMergeLogs(\StructType\GetContactMergeLogs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContactMergeLogs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSustainers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSustainers $parameters
     * @return \StructType\GetSustainersResponse|bool
     */
    public function GetSustainers(\StructType\GetSustainers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSustainers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPledges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPledges $parameters
     * @return \StructType\GetPledgesResponse|bool
     */
    public function GetPledges(\StructType\GetPledges $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPledges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMemberships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMemberships $parameters
     * @return \StructType\GetMembershipsResponse|bool
     */
    public function GetMemberships(\StructType\GetMemberships $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMemberships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransactions $parameters
     * @return \StructType\GetTransactionsResponse|bool
     */
    public function GetTransactions(\StructType\GetTransactions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetActivitiesResponse|\StructType\GetAddressesResponse|\StructType\GetCasesResponse|\StructType\GetChangeLogsResponse|\StructType\GetContactMergeLogsResponse|\StructType\GetContactsResponse|\StructType\GetCountriesResponse|\StructType\GetDoNotSolicitAddressesResponse|\StructType\GetDoNotSolicitEmailAddressesResponse|\StructType\GetDoNotSolicitPhoneNumbersResponse|\StructType\GetEmailAddressesResponse|\StructType\GetEventRegistrationsResponse|\StructType\GetEventsResponse|\StructType\GetFilesResponse|\StructType\GetGrassrootEventsResponse|\StructType\GetGroupsResponse|\StructType\GetInitiativeAudienceResponse|\StructType\GetInitiativeClickThroughsResponse|\StructType\GetInitiativeConversionsResponse|\StructType\GetInitiativeDeliveryFailuresResponse|\StructType\GetInitiativeMessageReturnsResponse|\StructType\GetInitiativeMessagesResponse|\StructType\GetInitiativeMessageViewsResponse|\StructType\GetInitiativePageVisitsResponse|\StructType\GetInitiativesResponse|\StructType\GetInstantMessengerIdsResponse|\StructType\GetMembershipsResponse|\StructType\GetNotesResponse|\StructType\GetOpportunitiesResponse|\StructType\GetOptInListContactsResponse|\StructType\GetOptInListsResponse|\StructType\GetPeerToPeerMicrositesResponse|\StructType\GetPeerToPeerPagesResponse|\StructType\GetPeerToPeerTeamsResponse|\StructType\GetPhoneNumbersResponse|\StructType\GetPledgesResponse|\StructType\GetRelationshipsResponse|\StructType\GetSocialMediaHandlesResponse|\StructType\GetStatesProvincesResponse|\StructType\GetSustainersResponse|\StructType\GetTagsResponse|\StructType\GetTransactionsResponse|\StructType\GetTributeAcknowledgeesResponse|\StructType\GetTributesResponse|\StructType\GetWebFormsResponse|\StructType\GetWebsitesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
