<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateCashPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCashPayment $parameters
     * @return \StructType\CreateCashPaymentResponse|bool
     */
    public function CreateCashPayment(\StructType\CreateCashPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCashPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOtherPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOtherPayments $parameters
     * @return \StructType\CreateOtherPaymentsResponse|bool
     */
    public function CreateOtherPayments(\StructType\CreateOtherPayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOtherPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOtherPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOtherPayment $parameters
     * @return \StructType\CreateOtherPaymentResponse|bool
     */
    public function CreateOtherPayment(\StructType\CreateOtherPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOtherPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTributes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTributes $parameters
     * @return \StructType\CreateTributesResponse|bool
     */
    public function CreateTributes(\StructType\CreateTributes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTributes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTribute $parameters
     * @return \StructType\CreateTributeResponse|bool
     */
    public function CreateTribute(\StructType\CreateTribute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTributeAcknowledgees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTributeAcknowledgees $parameters
     * @return \StructType\CreateTributeAcknowledgeesResponse|bool
     */
    public function CreateTributeAcknowledgees(\StructType\CreateTributeAcknowledgees $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTributeAcknowledgees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTributeAcknowledgee
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTributeAcknowledgee $parameters
     * @return \StructType\CreateTributeAcknowledgeeResponse|bool
     */
    public function CreateTributeAcknowledgee(\StructType\CreateTributeAcknowledgee $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateTributeAcknowledgee($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePeople $parameters
     * @return \StructType\CreatePeopleResponse|bool
     */
    public function CreatePeople(\StructType\CreatePeople $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePeople($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePerson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePerson $parameters
     * @return \StructType\CreatePersonResponse|bool
     */
    public function CreatePerson(\StructType\CreatePerson $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePerson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrganizations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrganizations $parameters
     * @return \StructType\CreateOrganizationsResponse|bool
     */
    public function CreateOrganizations(\StructType\CreateOrganizations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOrganizations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrganization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrganization $parameters
     * @return \StructType\CreateOrganizationResponse|bool
     */
    public function CreateOrganization(\StructType\CreateOrganization $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateOrganization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateHouseholds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateHouseholds $parameters
     * @return \StructType\CreateHouseholdsResponse|bool
     */
    public function CreateHouseholds(\StructType\CreateHouseholds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateHouseholds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateHousehold
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateHousehold $parameters
     * @return \StructType\CreateHouseholdResponse|bool
     */
    public function CreateHousehold(\StructType\CreateHousehold $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateHousehold($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAddresses $parameters
     * @return \StructType\CreateAddressesResponse|bool
     */
    public function CreateAddresses(\StructType\CreateAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAddress $parameters
     * @return \StructType\CreateAddressResponse|bool
     */
    public function CreateAddress(\StructType\CreateAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEmailAddresses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEmailAddresses $parameters
     * @return \StructType\CreateEmailAddressesResponse|bool
     */
    public function CreateEmailAddresses(\StructType\CreateEmailAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEmailAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateEmailAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateEmailAddress $parameters
     * @return \StructType\CreateEmailAddressResponse|bool
     */
    public function CreateEmailAddress(\StructType\CreateEmailAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEmailAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePhoneNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePhoneNumbers $parameters
     * @return \StructType\CreatePhoneNumbersResponse|bool
     */
    public function CreatePhoneNumbers(\StructType\CreatePhoneNumbers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePhoneNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePhoneNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePhoneNumber $parameters
     * @return \StructType\CreatePhoneNumberResponse|bool
     */
    public function CreatePhoneNumber(\StructType\CreatePhoneNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePhoneNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateInstantMessengerIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateInstantMessengerIds $parameters
     * @return \StructType\CreateInstantMessengerIdsResponse|bool
     */
    public function CreateInstantMessengerIds(\StructType\CreateInstantMessengerIds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateInstantMessengerIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateInstantMessengerId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateInstantMessengerId $parameters
     * @return \StructType\CreateInstantMessengerIdResponse|bool
     */
    public function CreateInstantMessengerId(\StructType\CreateInstantMessengerId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateInstantMessengerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSocialMediaHandles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSocialMediaHandles $parameters
     * @return \StructType\CreateSocialMediaHandlesResponse|bool
     */
    public function CreateSocialMediaHandles(\StructType\CreateSocialMediaHandles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSocialMediaHandles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSocialMediaHandle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSocialMediaHandle $parameters
     * @return \StructType\CreateSocialMediaHandleResponse|bool
     */
    public function CreateSocialMediaHandle(\StructType\CreateSocialMediaHandle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSocialMediaHandle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWebsites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateWebsites $parameters
     * @return \StructType\CreateWebsitesResponse|bool
     */
    public function CreateWebsites(\StructType\CreateWebsites $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWebsites($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateWebsite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateWebsite $parameters
     * @return \StructType\CreateWebsiteResponse|bool
     */
    public function CreateWebsite(\StructType\CreateWebsite $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateWebsite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateNotes $parameters
     * @return \StructType\CreateNotesResponse|bool
     */
    public function CreateNotes(\StructType\CreateNotes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateNote $parameters
     * @return \StructType\CreateNoteResponse|bool
     */
    public function CreateNote(\StructType\CreateNote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateFiles $parameters
     * @return \StructType\CreateFilesResponse|bool
     */
    public function CreateFiles(\StructType\CreateFiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateFile $parameters
     * @return \StructType\CreateFileResponse|bool
     */
    public function CreateFile(\StructType\CreateFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateActivities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateActivities $parameters
     * @return \StructType\CreateActivitiesResponse|bool
     */
    public function CreateActivities(\StructType\CreateActivities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateActivities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateActivity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateActivity $parameters
     * @return \StructType\CreateActivityResponse|bool
     */
    public function CreateActivity(\StructType\CreateActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateRelationships
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRelationships $parameters
     * @return \StructType\CreateRelationshipsResponse|bool
     */
    public function CreateRelationships(\StructType\CreateRelationships $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateRelationships($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateRelationship
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRelationship $parameters
     * @return \StructType\CreateRelationshipResponse|bool
     */
    public function CreateRelationship(\StructType\CreateRelationship $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateRelationship($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentProfiles $parameters
     * @return \StructType\CreatePaymentProfilesResponse|bool
     */
    public function CreatePaymentProfiles(\StructType\CreatePaymentProfiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentProfiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentProfile $parameters
     * @return \StructType\CreatePaymentProfileResponse|bool
     */
    public function CreatePaymentProfile(\StructType\CreatePaymentProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreatePaymentProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSustainers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSustainers $parameters
     * @return \StructType\CreateSustainersResponse|bool
     */
    public function CreateSustainers(\StructType\CreateSustainers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSustainers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSustainer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSustainer $parameters
     * @return \StructType\CreateSustainerResponse|bool
     */
    public function CreateSustainer(\StructType\CreateSustainer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateSustainer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCheckPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCheckPayments $parameters
     * @return \StructType\CreateCheckPaymentsResponse|bool
     */
    public function CreateCheckPayments(\StructType\CreateCheckPayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCheckPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCheckPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCheckPayment $parameters
     * @return \StructType\CreateCheckPaymentResponse|bool
     */
    public function CreateCheckPayment(\StructType\CreateCheckPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCheckPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCashPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCashPayments $parameters
     * @return \StructType\CreateCashPaymentsResponse|bool
     */
    public function CreateCashPayments(\StructType\CreateCashPayments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateCashPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateActivitiesResponse|\StructType\CreateActivityResponse|\StructType\CreateAddressesResponse|\StructType\CreateAddressResponse|\StructType\CreateCashPaymentResponse|\StructType\CreateCashPaymentsResponse|\StructType\CreateCheckPaymentResponse|\StructType\CreateCheckPaymentsResponse|\StructType\CreateEmailAddressesResponse|\StructType\CreateEmailAddressResponse|\StructType\CreateFileResponse|\StructType\CreateFilesResponse|\StructType\CreateHouseholdResponse|\StructType\CreateHouseholdsResponse|\StructType\CreateInstantMessengerIdResponse|\StructType\CreateInstantMessengerIdsResponse|\StructType\CreateNoteResponse|\StructType\CreateNotesResponse|\StructType\CreateOrganizationResponse|\StructType\CreateOrganizationsResponse|\StructType\CreateOtherPaymentResponse|\StructType\CreateOtherPaymentsResponse|\StructType\CreatePaymentProfileResponse|\StructType\CreatePaymentProfilesResponse|\StructType\CreatePeopleResponse|\StructType\CreatePersonResponse|\StructType\CreatePhoneNumberResponse|\StructType\CreatePhoneNumbersResponse|\StructType\CreateRelationshipResponse|\StructType\CreateRelationshipsResponse|\StructType\CreateSocialMediaHandleResponse|\StructType\CreateSocialMediaHandlesResponse|\StructType\CreateSustainerResponse|\StructType\CreateSustainersResponse|\StructType\CreateTributeAcknowledgeeResponse|\StructType\CreateTributeAcknowledgeesResponse|\StructType\CreateTributeResponse|\StructType\CreateTributesResponse|\StructType\CreateWebsiteResponse|\StructType\CreateWebsitesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
