<?php

namespace EnumType;

/**
 * This class stands for TributeTypes EnumType
 * @subpackage Enumerations
 */
class TributeTypes
{
    /**
     * Constant for value 'InHonorOf'
     * @return string 'InHonorOf'
     */
    const VALUE_IN_HONOR_OF = 'InHonorOf';
    /**
     * Constant for value 'InMemoryOf'
     * @return string 'InMemoryOf'
     */
    const VALUE_IN_MEMORY_OF = 'InMemoryOf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IN_HONOR_OF
     * @uses self::VALUE_IN_MEMORY_OF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IN_HONOR_OF,
            self::VALUE_IN_MEMORY_OF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
