<?php

namespace EnumType;

/**
 * This class stands for PhoneNumberClasses EnumType
 * @subpackage Enumerations
 */
class PhoneNumberClasses
{
    /**
     * Constant for value 'Landline'
     * @return string 'Landline'
     */
    const VALUE_LANDLINE = 'Landline';
    /**
     * Constant for value 'Mobile'
     * @return string 'Mobile'
     */
    const VALUE_MOBILE = 'Mobile';
    /**
     * Constant for value 'Fax'
     * @return string 'Fax'
     */
    const VALUE_FAX = 'Fax';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LANDLINE
     * @uses self::VALUE_MOBILE
     * @uses self::VALUE_FAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LANDLINE,
            self::VALUE_MOBILE,
            self::VALUE_FAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
