<?php

namespace EnumType;

/**
 * This class stands for EditSustainerPaymentModes EnumType
 * @subpackage Enumerations
 */
class EditSustainerPaymentModes
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'AuthorizeFormOfPayment'
     * @return string 'AuthorizeFormOfPayment'
     */
    const VALUE_AUTHORIZE_FORM_OF_PAYMENT = 'AuthorizeFormOfPayment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AUTHORIZE_FORM_OF_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AUTHORIZE_FORM_OF_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
