<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValidationMessage ArrayType
 * @subpackage Arrays
 */
class ArrayOfValidationMessage extends AbstractStructArrayBase
{
    /**
     * The ValidationMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidationMessage[]
     */
    public $ValidationMessage;
    /**
     * Constructor method for ArrayOfValidationMessage
     * @uses ArrayOfValidationMessage::setValidationMessage()
     * @param \StructType\ValidationMessage[] $validationMessage
     */
    public function __construct(array $validationMessage = array())
    {
        $this
            ->setValidationMessage($validationMessage);
    }
    /**
     * Get ValidationMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidationMessage[]|null
     */
    public function getValidationMessage()
    {
        return isset($this->ValidationMessage) ? $this->ValidationMessage : null;
    }
    /**
     * Set ValidationMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationMessage[] $validationMessage
     * @return \ArrayType\ArrayOfValidationMessage
     */
    public function setValidationMessage(array $validationMessage = array())
    {
        foreach ($validationMessage as $arrayOfValidationMessageValidationMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfValidationMessageValidationMessageItem instanceof \StructType\ValidationMessage) {
                throw new \InvalidArgumentException(sprintf('The ValidationMessage property can only contain items of \StructType\ValidationMessage, "%s" given', is_object($arrayOfValidationMessageValidationMessageItem) ? get_class($arrayOfValidationMessageValidationMessageItem) : gettype($arrayOfValidationMessageValidationMessageItem)), __LINE__);
            }
        }
        if (is_null($validationMessage) || (is_array($validationMessage) && empty($validationMessage))) {
            unset($this->ValidationMessage);
        } else {
            $this->ValidationMessage = $validationMessage;
        }
        return $this;
    }
    /**
     * Add item to ValidationMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationMessage $item
     * @return \ArrayType\ArrayOfValidationMessage
     */
    public function addToValidationMessage(\StructType\ValidationMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationMessage) {
            throw new \InvalidArgumentException(sprintf('The ValidationMessage property can only contain items of \StructType\ValidationMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidationMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ValidationMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ValidationMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ValidationMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ValidationMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ValidationMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValidationMessage
     */
    public function getAttributeName()
    {
        return 'ValidationMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfValidationMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
