<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFindOrCreateContactResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfFindOrCreateContactResponse extends AbstractStructArrayBase
{
    /**
     * The FindOrCreateContactResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FindOrCreateContactResponse[]
     */
    public $FindOrCreateContactResponse;
    /**
     * Constructor method for ArrayOfFindOrCreateContactResponse
     * @uses ArrayOfFindOrCreateContactResponse::setFindOrCreateContactResponse()
     * @param \StructType\FindOrCreateContactResponse[] $findOrCreateContactResponse
     */
    public function __construct(array $findOrCreateContactResponse = array())
    {
        $this
            ->setFindOrCreateContactResponse($findOrCreateContactResponse);
    }
    /**
     * Get FindOrCreateContactResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FindOrCreateContactResponse[]|null
     */
    public function getFindOrCreateContactResponse()
    {
        return isset($this->FindOrCreateContactResponse) ? $this->FindOrCreateContactResponse : null;
    }
    /**
     * Set FindOrCreateContactResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateContactResponse[] $findOrCreateContactResponse
     * @return \ArrayType\ArrayOfFindOrCreateContactResponse
     */
    public function setFindOrCreateContactResponse(array $findOrCreateContactResponse = array())
    {
        foreach ($findOrCreateContactResponse as $arrayOfFindOrCreateContactResponseFindOrCreateContactResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfFindOrCreateContactResponseFindOrCreateContactResponseItem instanceof \StructType\FindOrCreateContactResponse) {
                throw new \InvalidArgumentException(sprintf('The FindOrCreateContactResponse property can only contain items of \StructType\FindOrCreateContactResponse, "%s" given', is_object($arrayOfFindOrCreateContactResponseFindOrCreateContactResponseItem) ? get_class($arrayOfFindOrCreateContactResponseFindOrCreateContactResponseItem) : gettype($arrayOfFindOrCreateContactResponseFindOrCreateContactResponseItem)), __LINE__);
            }
        }
        if (is_null($findOrCreateContactResponse) || (is_array($findOrCreateContactResponse) && empty($findOrCreateContactResponse))) {
            unset($this->FindOrCreateContactResponse);
        } else {
            $this->FindOrCreateContactResponse = $findOrCreateContactResponse;
        }
        return $this;
    }
    /**
     * Add item to FindOrCreateContactResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateContactResponse $item
     * @return \ArrayType\ArrayOfFindOrCreateContactResponse
     */
    public function addToFindOrCreateContactResponse(\StructType\FindOrCreateContactResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FindOrCreateContactResponse) {
            throw new \InvalidArgumentException(sprintf('The FindOrCreateContactResponse property can only contain items of \StructType\FindOrCreateContactResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FindOrCreateContactResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FindOrCreateContactResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FindOrCreateContactResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FindOrCreateContactResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FindOrCreateContactResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FindOrCreateContactResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FindOrCreateContactResponse
     */
    public function getAttributeName()
    {
        return 'FindOrCreateContactResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFindOrCreateContactResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
