<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventRecord extends AbstractStructArrayBase
{
    /**
     * The EventRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventRecord[]
     */
    public $EventRecord;
    /**
     * Constructor method for ArrayOfEventRecord
     * @uses ArrayOfEventRecord::setEventRecord()
     * @param \StructType\EventRecord[] $eventRecord
     */
    public function __construct(array $eventRecord = array())
    {
        $this
            ->setEventRecord($eventRecord);
    }
    /**
     * Get EventRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventRecord[]|null
     */
    public function getEventRecord()
    {
        return isset($this->EventRecord) ? $this->EventRecord : null;
    }
    /**
     * Set EventRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventRecord[] $eventRecord
     * @return \ArrayType\ArrayOfEventRecord
     */
    public function setEventRecord(array $eventRecord = array())
    {
        foreach ($eventRecord as $arrayOfEventRecordEventRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventRecordEventRecordItem instanceof \StructType\EventRecord) {
                throw new \InvalidArgumentException(sprintf('The EventRecord property can only contain items of \StructType\EventRecord, "%s" given', is_object($arrayOfEventRecordEventRecordItem) ? get_class($arrayOfEventRecordEventRecordItem) : gettype($arrayOfEventRecordEventRecordItem)), __LINE__);
            }
        }
        if (is_null($eventRecord) || (is_array($eventRecord) && empty($eventRecord))) {
            unset($this->EventRecord);
        } else {
            $this->EventRecord = $eventRecord;
        }
        return $this;
    }
    /**
     * Add item to EventRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\EventRecord $item
     * @return \ArrayType\ArrayOfEventRecord
     */
    public function addToEventRecord(\StructType\EventRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventRecord) {
            throw new \InvalidArgumentException(sprintf('The EventRecord property can only contain items of \StructType\EventRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EventRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventRecord
     */
    public function getAttributeName()
    {
        return 'EventRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEventRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
