<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditTransactionResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditTransactionResponse extends AbstractStructArrayBase
{
    /**
     * The EditTransactionResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditTransactionResponse[]
     */
    public $EditTransactionResponse;
    /**
     * Constructor method for ArrayOfEditTransactionResponse
     * @uses ArrayOfEditTransactionResponse::setEditTransactionResponse()
     * @param \StructType\EditTransactionResponse[] $editTransactionResponse
     */
    public function __construct(array $editTransactionResponse = array())
    {
        $this
            ->setEditTransactionResponse($editTransactionResponse);
    }
    /**
     * Get EditTransactionResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditTransactionResponse[]|null
     */
    public function getEditTransactionResponse()
    {
        return isset($this->EditTransactionResponse) ? $this->EditTransactionResponse : null;
    }
    /**
     * Set EditTransactionResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditTransactionResponse[] $editTransactionResponse
     * @return \ArrayType\ArrayOfEditTransactionResponse
     */
    public function setEditTransactionResponse(array $editTransactionResponse = array())
    {
        foreach ($editTransactionResponse as $arrayOfEditTransactionResponseEditTransactionResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditTransactionResponseEditTransactionResponseItem instanceof \StructType\EditTransactionResponse) {
                throw new \InvalidArgumentException(sprintf('The EditTransactionResponse property can only contain items of \StructType\EditTransactionResponse, "%s" given', is_object($arrayOfEditTransactionResponseEditTransactionResponseItem) ? get_class($arrayOfEditTransactionResponseEditTransactionResponseItem) : gettype($arrayOfEditTransactionResponseEditTransactionResponseItem)), __LINE__);
            }
        }
        if (is_null($editTransactionResponse) || (is_array($editTransactionResponse) && empty($editTransactionResponse))) {
            unset($this->EditTransactionResponse);
        } else {
            $this->EditTransactionResponse = $editTransactionResponse;
        }
        return $this;
    }
    /**
     * Add item to EditTransactionResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditTransactionResponse $item
     * @return \ArrayType\ArrayOfEditTransactionResponse
     */
    public function addToEditTransactionResponse(\StructType\EditTransactionResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditTransactionResponse) {
            throw new \InvalidArgumentException(sprintf('The EditTransactionResponse property can only contain items of \StructType\EditTransactionResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditTransactionResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditTransactionResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditTransactionResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditTransactionResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditTransactionResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditTransactionResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditTransactionResponse
     */
    public function getAttributeName()
    {
        return 'EditTransactionResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditTransactionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
