<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditPhoneNumberParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditPhoneNumberParameters extends AbstractStructArrayBase
{
    /**
     * The EditPhoneNumberParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditPhoneNumberParameters[]
     */
    public $EditPhoneNumberParameters;
    /**
     * Constructor method for ArrayOfEditPhoneNumberParameters
     * @uses ArrayOfEditPhoneNumberParameters::setEditPhoneNumberParameters()
     * @param \StructType\EditPhoneNumberParameters[] $editPhoneNumberParameters
     */
    public function __construct(array $editPhoneNumberParameters = array())
    {
        $this
            ->setEditPhoneNumberParameters($editPhoneNumberParameters);
    }
    /**
     * Get EditPhoneNumberParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditPhoneNumberParameters[]|null
     */
    public function getEditPhoneNumberParameters()
    {
        return isset($this->EditPhoneNumberParameters) ? $this->EditPhoneNumberParameters : null;
    }
    /**
     * Set EditPhoneNumberParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditPhoneNumberParameters[] $editPhoneNumberParameters
     * @return \ArrayType\ArrayOfEditPhoneNumberParameters
     */
    public function setEditPhoneNumberParameters(array $editPhoneNumberParameters = array())
    {
        foreach ($editPhoneNumberParameters as $arrayOfEditPhoneNumberParametersEditPhoneNumberParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditPhoneNumberParametersEditPhoneNumberParametersItem instanceof \StructType\EditPhoneNumberParameters) {
                throw new \InvalidArgumentException(sprintf('The EditPhoneNumberParameters property can only contain items of \StructType\EditPhoneNumberParameters, "%s" given', is_object($arrayOfEditPhoneNumberParametersEditPhoneNumberParametersItem) ? get_class($arrayOfEditPhoneNumberParametersEditPhoneNumberParametersItem) : gettype($arrayOfEditPhoneNumberParametersEditPhoneNumberParametersItem)), __LINE__);
            }
        }
        if (is_null($editPhoneNumberParameters) || (is_array($editPhoneNumberParameters) && empty($editPhoneNumberParameters))) {
            unset($this->EditPhoneNumberParameters);
        } else {
            $this->EditPhoneNumberParameters = $editPhoneNumberParameters;
        }
        return $this;
    }
    /**
     * Add item to EditPhoneNumberParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditPhoneNumberParameters $item
     * @return \ArrayType\ArrayOfEditPhoneNumberParameters
     */
    public function addToEditPhoneNumberParameters(\StructType\EditPhoneNumberParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditPhoneNumberParameters) {
            throw new \InvalidArgumentException(sprintf('The EditPhoneNumberParameters property can only contain items of \StructType\EditPhoneNumberParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditPhoneNumberParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditPhoneNumberParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditPhoneNumberParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditPhoneNumberParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditPhoneNumberParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditPhoneNumberParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditPhoneNumberParameters
     */
    public function getAttributeName()
    {
        return 'EditPhoneNumberParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditPhoneNumberParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
