<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditOrganizationParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditOrganizationParameters extends AbstractStructArrayBase
{
    /**
     * The EditOrganizationParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditOrganizationParameters[]
     */
    public $EditOrganizationParameters;
    /**
     * Constructor method for ArrayOfEditOrganizationParameters
     * @uses ArrayOfEditOrganizationParameters::setEditOrganizationParameters()
     * @param \StructType\EditOrganizationParameters[] $editOrganizationParameters
     */
    public function __construct(array $editOrganizationParameters = array())
    {
        $this
            ->setEditOrganizationParameters($editOrganizationParameters);
    }
    /**
     * Get EditOrganizationParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditOrganizationParameters[]|null
     */
    public function getEditOrganizationParameters()
    {
        return isset($this->EditOrganizationParameters) ? $this->EditOrganizationParameters : null;
    }
    /**
     * Set EditOrganizationParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditOrganizationParameters[] $editOrganizationParameters
     * @return \ArrayType\ArrayOfEditOrganizationParameters
     */
    public function setEditOrganizationParameters(array $editOrganizationParameters = array())
    {
        foreach ($editOrganizationParameters as $arrayOfEditOrganizationParametersEditOrganizationParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditOrganizationParametersEditOrganizationParametersItem instanceof \StructType\EditOrganizationParameters) {
                throw new \InvalidArgumentException(sprintf('The EditOrganizationParameters property can only contain items of \StructType\EditOrganizationParameters, "%s" given', is_object($arrayOfEditOrganizationParametersEditOrganizationParametersItem) ? get_class($arrayOfEditOrganizationParametersEditOrganizationParametersItem) : gettype($arrayOfEditOrganizationParametersEditOrganizationParametersItem)), __LINE__);
            }
        }
        if (is_null($editOrganizationParameters) || (is_array($editOrganizationParameters) && empty($editOrganizationParameters))) {
            unset($this->EditOrganizationParameters);
        } else {
            $this->EditOrganizationParameters = $editOrganizationParameters;
        }
        return $this;
    }
    /**
     * Add item to EditOrganizationParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditOrganizationParameters $item
     * @return \ArrayType\ArrayOfEditOrganizationParameters
     */
    public function addToEditOrganizationParameters(\StructType\EditOrganizationParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditOrganizationParameters) {
            throw new \InvalidArgumentException(sprintf('The EditOrganizationParameters property can only contain items of \StructType\EditOrganizationParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditOrganizationParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditOrganizationParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditOrganizationParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditOrganizationParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditOrganizationParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditOrganizationParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditOrganizationParameters
     */
    public function getAttributeName()
    {
        return 'EditOrganizationParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditOrganizationParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
