<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteWebsiteParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteWebsiteParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteWebsiteParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteWebsiteParameters[]
     */
    public $DeleteWebsiteParameters;
    /**
     * Constructor method for ArrayOfDeleteWebsiteParameters
     * @uses ArrayOfDeleteWebsiteParameters::setDeleteWebsiteParameters()
     * @param \StructType\DeleteWebsiteParameters[] $deleteWebsiteParameters
     */
    public function __construct(array $deleteWebsiteParameters = array())
    {
        $this
            ->setDeleteWebsiteParameters($deleteWebsiteParameters);
    }
    /**
     * Get DeleteWebsiteParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteWebsiteParameters[]|null
     */
    public function getDeleteWebsiteParameters()
    {
        return isset($this->DeleteWebsiteParameters) ? $this->DeleteWebsiteParameters : null;
    }
    /**
     * Set DeleteWebsiteParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteWebsiteParameters[] $deleteWebsiteParameters
     * @return \ArrayType\ArrayOfDeleteWebsiteParameters
     */
    public function setDeleteWebsiteParameters(array $deleteWebsiteParameters = array())
    {
        foreach ($deleteWebsiteParameters as $arrayOfDeleteWebsiteParametersDeleteWebsiteParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteWebsiteParametersDeleteWebsiteParametersItem instanceof \StructType\DeleteWebsiteParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteWebsiteParameters property can only contain items of \StructType\DeleteWebsiteParameters, "%s" given', is_object($arrayOfDeleteWebsiteParametersDeleteWebsiteParametersItem) ? get_class($arrayOfDeleteWebsiteParametersDeleteWebsiteParametersItem) : gettype($arrayOfDeleteWebsiteParametersDeleteWebsiteParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteWebsiteParameters) || (is_array($deleteWebsiteParameters) && empty($deleteWebsiteParameters))) {
            unset($this->DeleteWebsiteParameters);
        } else {
            $this->DeleteWebsiteParameters = $deleteWebsiteParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteWebsiteParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteWebsiteParameters $item
     * @return \ArrayType\ArrayOfDeleteWebsiteParameters
     */
    public function addToDeleteWebsiteParameters(\StructType\DeleteWebsiteParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteWebsiteParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteWebsiteParameters property can only contain items of \StructType\DeleteWebsiteParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteWebsiteParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteWebsiteParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteWebsiteParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteWebsiteParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteWebsiteParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteWebsiteParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteWebsiteParameters
     */
    public function getAttributeName()
    {
        return 'DeleteWebsiteParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteWebsiteParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
