<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteSustainerResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteSustainerResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteSustainerResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteSustainerResponse[]
     */
    public $DeleteSustainerResponse;
    /**
     * Constructor method for ArrayOfDeleteSustainerResponse
     * @uses ArrayOfDeleteSustainerResponse::setDeleteSustainerResponse()
     * @param \StructType\DeleteSustainerResponse[] $deleteSustainerResponse
     */
    public function __construct(array $deleteSustainerResponse = array())
    {
        $this
            ->setDeleteSustainerResponse($deleteSustainerResponse);
    }
    /**
     * Get DeleteSustainerResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteSustainerResponse[]|null
     */
    public function getDeleteSustainerResponse()
    {
        return isset($this->DeleteSustainerResponse) ? $this->DeleteSustainerResponse : null;
    }
    /**
     * Set DeleteSustainerResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSustainerResponse[] $deleteSustainerResponse
     * @return \ArrayType\ArrayOfDeleteSustainerResponse
     */
    public function setDeleteSustainerResponse(array $deleteSustainerResponse = array())
    {
        foreach ($deleteSustainerResponse as $arrayOfDeleteSustainerResponseDeleteSustainerResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteSustainerResponseDeleteSustainerResponseItem instanceof \StructType\DeleteSustainerResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteSustainerResponse property can only contain items of \StructType\DeleteSustainerResponse, "%s" given', is_object($arrayOfDeleteSustainerResponseDeleteSustainerResponseItem) ? get_class($arrayOfDeleteSustainerResponseDeleteSustainerResponseItem) : gettype($arrayOfDeleteSustainerResponseDeleteSustainerResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteSustainerResponse) || (is_array($deleteSustainerResponse) && empty($deleteSustainerResponse))) {
            unset($this->DeleteSustainerResponse);
        } else {
            $this->DeleteSustainerResponse = $deleteSustainerResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteSustainerResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSustainerResponse $item
     * @return \ArrayType\ArrayOfDeleteSustainerResponse
     */
    public function addToDeleteSustainerResponse(\StructType\DeleteSustainerResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteSustainerResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteSustainerResponse property can only contain items of \StructType\DeleteSustainerResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteSustainerResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteSustainerResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteSustainerResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteSustainerResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteSustainerResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteSustainerResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteSustainerResponse
     */
    public function getAttributeName()
    {
        return 'DeleteSustainerResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteSustainerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
