<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteNoteParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteNoteParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteNoteParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteNoteParameters[]
     */
    public $DeleteNoteParameters;
    /**
     * Constructor method for ArrayOfDeleteNoteParameters
     * @uses ArrayOfDeleteNoteParameters::setDeleteNoteParameters()
     * @param \StructType\DeleteNoteParameters[] $deleteNoteParameters
     */
    public function __construct(array $deleteNoteParameters = array())
    {
        $this
            ->setDeleteNoteParameters($deleteNoteParameters);
    }
    /**
     * Get DeleteNoteParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteNoteParameters[]|null
     */
    public function getDeleteNoteParameters()
    {
        return isset($this->DeleteNoteParameters) ? $this->DeleteNoteParameters : null;
    }
    /**
     * Set DeleteNoteParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteNoteParameters[] $deleteNoteParameters
     * @return \ArrayType\ArrayOfDeleteNoteParameters
     */
    public function setDeleteNoteParameters(array $deleteNoteParameters = array())
    {
        foreach ($deleteNoteParameters as $arrayOfDeleteNoteParametersDeleteNoteParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteNoteParametersDeleteNoteParametersItem instanceof \StructType\DeleteNoteParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteNoteParameters property can only contain items of \StructType\DeleteNoteParameters, "%s" given', is_object($arrayOfDeleteNoteParametersDeleteNoteParametersItem) ? get_class($arrayOfDeleteNoteParametersDeleteNoteParametersItem) : gettype($arrayOfDeleteNoteParametersDeleteNoteParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteNoteParameters) || (is_array($deleteNoteParameters) && empty($deleteNoteParameters))) {
            unset($this->DeleteNoteParameters);
        } else {
            $this->DeleteNoteParameters = $deleteNoteParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteNoteParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteNoteParameters $item
     * @return \ArrayType\ArrayOfDeleteNoteParameters
     */
    public function addToDeleteNoteParameters(\StructType\DeleteNoteParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteNoteParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteNoteParameters property can only contain items of \StructType\DeleteNoteParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteNoteParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteNoteParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteNoteParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteNoteParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteNoteParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteNoteParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteNoteParameters
     */
    public function getAttributeName()
    {
        return 'DeleteNoteParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteNoteParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
