<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteEmailAddressParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteEmailAddressParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteEmailAddressParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteEmailAddressParameters[]
     */
    public $DeleteEmailAddressParameters;
    /**
     * Constructor method for ArrayOfDeleteEmailAddressParameters
     * @uses ArrayOfDeleteEmailAddressParameters::setDeleteEmailAddressParameters()
     * @param \StructType\DeleteEmailAddressParameters[] $deleteEmailAddressParameters
     */
    public function __construct(array $deleteEmailAddressParameters = array())
    {
        $this
            ->setDeleteEmailAddressParameters($deleteEmailAddressParameters);
    }
    /**
     * Get DeleteEmailAddressParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteEmailAddressParameters[]|null
     */
    public function getDeleteEmailAddressParameters()
    {
        return isset($this->DeleteEmailAddressParameters) ? $this->DeleteEmailAddressParameters : null;
    }
    /**
     * Set DeleteEmailAddressParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteEmailAddressParameters[] $deleteEmailAddressParameters
     * @return \ArrayType\ArrayOfDeleteEmailAddressParameters
     */
    public function setDeleteEmailAddressParameters(array $deleteEmailAddressParameters = array())
    {
        foreach ($deleteEmailAddressParameters as $arrayOfDeleteEmailAddressParametersDeleteEmailAddressParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteEmailAddressParametersDeleteEmailAddressParametersItem instanceof \StructType\DeleteEmailAddressParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteEmailAddressParameters property can only contain items of \StructType\DeleteEmailAddressParameters, "%s" given', is_object($arrayOfDeleteEmailAddressParametersDeleteEmailAddressParametersItem) ? get_class($arrayOfDeleteEmailAddressParametersDeleteEmailAddressParametersItem) : gettype($arrayOfDeleteEmailAddressParametersDeleteEmailAddressParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteEmailAddressParameters) || (is_array($deleteEmailAddressParameters) && empty($deleteEmailAddressParameters))) {
            unset($this->DeleteEmailAddressParameters);
        } else {
            $this->DeleteEmailAddressParameters = $deleteEmailAddressParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteEmailAddressParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteEmailAddressParameters $item
     * @return \ArrayType\ArrayOfDeleteEmailAddressParameters
     */
    public function addToDeleteEmailAddressParameters(\StructType\DeleteEmailAddressParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteEmailAddressParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteEmailAddressParameters property can only contain items of \StructType\DeleteEmailAddressParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteEmailAddressParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteEmailAddressParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteEmailAddressParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteEmailAddressParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteEmailAddressParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteEmailAddressParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteEmailAddressParameters
     */
    public function getAttributeName()
    {
        return 'DeleteEmailAddressParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteEmailAddressParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
