<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAuthorizeCreditCardParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfAuthorizeCreditCardParameters extends AbstractStructArrayBase
{
    /**
     * The AuthorizeCreditCardParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthorizeCreditCardParameters[]
     */
    public $AuthorizeCreditCardParameters;
    /**
     * Constructor method for ArrayOfAuthorizeCreditCardParameters
     * @uses ArrayOfAuthorizeCreditCardParameters::setAuthorizeCreditCardParameters()
     * @param \StructType\AuthorizeCreditCardParameters[] $authorizeCreditCardParameters
     */
    public function __construct(array $authorizeCreditCardParameters = array())
    {
        $this
            ->setAuthorizeCreditCardParameters($authorizeCreditCardParameters);
    }
    /**
     * Get AuthorizeCreditCardParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthorizeCreditCardParameters[]|null
     */
    public function getAuthorizeCreditCardParameters()
    {
        return isset($this->AuthorizeCreditCardParameters) ? $this->AuthorizeCreditCardParameters : null;
    }
    /**
     * Set AuthorizeCreditCardParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizeCreditCardParameters[] $authorizeCreditCardParameters
     * @return \ArrayType\ArrayOfAuthorizeCreditCardParameters
     */
    public function setAuthorizeCreditCardParameters(array $authorizeCreditCardParameters = array())
    {
        foreach ($authorizeCreditCardParameters as $arrayOfAuthorizeCreditCardParametersAuthorizeCreditCardParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfAuthorizeCreditCardParametersAuthorizeCreditCardParametersItem instanceof \StructType\AuthorizeCreditCardParameters) {
                throw new \InvalidArgumentException(sprintf('The AuthorizeCreditCardParameters property can only contain items of \StructType\AuthorizeCreditCardParameters, "%s" given', is_object($arrayOfAuthorizeCreditCardParametersAuthorizeCreditCardParametersItem) ? get_class($arrayOfAuthorizeCreditCardParametersAuthorizeCreditCardParametersItem) : gettype($arrayOfAuthorizeCreditCardParametersAuthorizeCreditCardParametersItem)), __LINE__);
            }
        }
        if (is_null($authorizeCreditCardParameters) || (is_array($authorizeCreditCardParameters) && empty($authorizeCreditCardParameters))) {
            unset($this->AuthorizeCreditCardParameters);
        } else {
            $this->AuthorizeCreditCardParameters = $authorizeCreditCardParameters;
        }
        return $this;
    }
    /**
     * Add item to AuthorizeCreditCardParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorizeCreditCardParameters $item
     * @return \ArrayType\ArrayOfAuthorizeCreditCardParameters
     */
    public function addToAuthorizeCreditCardParameters(\StructType\AuthorizeCreditCardParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorizeCreditCardParameters) {
            throw new \InvalidArgumentException(sprintf('The AuthorizeCreditCardParameters property can only contain items of \StructType\AuthorizeCreditCardParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AuthorizeCreditCardParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AuthorizeCreditCardParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AuthorizeCreditCardParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AuthorizeCreditCardParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AuthorizeCreditCardParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AuthorizeCreditCardParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AuthorizeCreditCardParameters
     */
    public function getAttributeName()
    {
        return 'AuthorizeCreditCardParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAuthorizeCreditCardParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
