<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddressRecord extends AbstractStructArrayBase
{
    /**
     * The AddressRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressRecord[]
     */
    public $AddressRecord;
    /**
     * Constructor method for ArrayOfAddressRecord
     * @uses ArrayOfAddressRecord::setAddressRecord()
     * @param \StructType\AddressRecord[] $addressRecord
     */
    public function __construct(array $addressRecord = array())
    {
        $this
            ->setAddressRecord($addressRecord);
    }
    /**
     * Get AddressRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressRecord[]|null
     */
    public function getAddressRecord()
    {
        return isset($this->AddressRecord) ? $this->AddressRecord : null;
    }
    /**
     * Set AddressRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddressRecord[] $addressRecord
     * @return \ArrayType\ArrayOfAddressRecord
     */
    public function setAddressRecord(array $addressRecord = array())
    {
        foreach ($addressRecord as $arrayOfAddressRecordAddressRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressRecordAddressRecordItem instanceof \StructType\AddressRecord) {
                throw new \InvalidArgumentException(sprintf('The AddressRecord property can only contain items of \StructType\AddressRecord, "%s" given', is_object($arrayOfAddressRecordAddressRecordItem) ? get_class($arrayOfAddressRecordAddressRecordItem) : gettype($arrayOfAddressRecordAddressRecordItem)), __LINE__);
            }
        }
        if (is_null($addressRecord) || (is_array($addressRecord) && empty($addressRecord))) {
            unset($this->AddressRecord);
        } else {
            $this->AddressRecord = $addressRecord;
        }
        return $this;
    }
    /**
     * Add item to AddressRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressRecord $item
     * @return \ArrayType\ArrayOfAddressRecord
     */
    public function addToAddressRecord(\StructType\AddressRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressRecord) {
            throw new \InvalidArgumentException(sprintf('The AddressRecord property can only contain items of \StructType\AddressRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AddressRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AddressRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AddressRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AddressRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AddressRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressRecord
     */
    public function getAttributeName()
    {
        return 'AddressRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAddressRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
