<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebServiceAuthentication StructType
 * @subpackage Structs
 */
class WebServiceAuthentication extends AbstractStructBase
{
    /**
     * The AuthenticationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AuthenticationType;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The AuthenticationToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthenticationToken;
    /**
     * Constructor method for WebServiceAuthentication
     * @uses WebServiceAuthentication::setAuthenticationType()
     * @uses WebServiceAuthentication::setUsername()
     * @uses WebServiceAuthentication::setPassword()
     * @uses WebServiceAuthentication::setAuthenticationToken()
     * @param string $authenticationType
     * @param string $username
     * @param string $password
     * @param string $authenticationToken
     */
    public function __construct($authenticationType = null, $username = null, $password = null, $authenticationToken = null)
    {
        $this
            ->setAuthenticationType($authenticationType)
            ->setUsername($username)
            ->setPassword($password)
            ->setAuthenticationToken($authenticationToken);
    }
    /**
     * Get AuthenticationType value
     * @return string
     */
    public function getAuthenticationType()
    {
        return $this->AuthenticationType;
    }
    /**
     * Set AuthenticationType value
     * @uses \EnumType\AuthenticationTypes::valueIsValid()
     * @uses \EnumType\AuthenticationTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \StructType\WebServiceAuthentication
     */
    public function setAuthenticationType($authenticationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthenticationTypes::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationType, implode(', ', \EnumType\AuthenticationTypes::getValidValues())), __LINE__);
        }
        $this->AuthenticationType = $authenticationType;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\WebServiceAuthentication
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\WebServiceAuthentication
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get AuthenticationToken value
     * @return string|null
     */
    public function getAuthenticationToken()
    {
        return $this->AuthenticationToken;
    }
    /**
     * Set AuthenticationToken value
     * @param string $authenticationToken
     * @return \StructType\WebServiceAuthentication
     */
    public function setAuthenticationToken($authenticationToken = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationToken) && !is_string($authenticationToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationToken)), __LINE__);
        }
        $this->AuthenticationToken = $authenticationToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebServiceAuthentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
