<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRecord StructType
 * @subpackage Structs
 */
class TransactionRecord extends DataRecord
{
    /**
     * The Sustainer_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sustainer_Id;
    /**
     * The Pledge_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Pledge_Id;
    /**
     * The Membership_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Membership_Id;
    /**
     * The Invoice_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Invoice_Id;
    /**
     * The TransactionDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TransactionDate;
    /**
     * The Form_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Form_Id;
    /**
     * The FormView_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FormView_Id;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The TicketSaleAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TicketSaleAmount;
    /**
     * The Confirmed
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Confirmed;
    /**
     * The Promo_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Promo_Id;
    /**
     * The PromoCode_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PromoCode_Id;
    /**
     * The MakeAnonymous
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $MakeAnonymous;
    /**
     * The HideAmountOnline
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $HideAmountOnline;
    /**
     * The IsRefunded
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsRefunded;
    /**
     * The RefundedTransaction_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RefundedTransaction_Id;
    /**
     * The TransactionBatch_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TransactionBatch_Id;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TransactionCategory
     */
    public $Category;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethod
     */
    public $PaymentMethod;
    /**
     * The ContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerDetail
     */
    public $ContactInfo;
    /**
     * The BillingDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingInfoCollection
     */
    public $BillingDetail;
    /**
     * The RelatedOrganization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrganizationSummary
     */
    public $RelatedOrganization;
    /**
     * The ElectronicTransactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ElectronicTransactionType
     */
    public $ElectronicTransactionType;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionInfoCollection
     */
    public $Attribution;
    /**
     * The DisplayNameOnlineAs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayNameOnlineAs;
    /**
     * The CheckNumber
     * @var string
     */
    public $CheckNumber;
    /**
     * The PaymentResultCode
     * @var string
     */
    public $PaymentResultCode;
    /**
     * The PaymentResultMessage
     * @var string
     */
    public $PaymentResultMessage;
    /**
     * The CreditCardNumberLastFour
     * @var string
     */
    public $CreditCardNumberLastFour;
    /**
     * The AchAccountNumberLastFour
     * @var string
     */
    public $AchAccountNumberLastFour;
    /**
     * Constructor method for TransactionRecord
     * @uses TransactionRecord::setSustainer_Id()
     * @uses TransactionRecord::setPledge_Id()
     * @uses TransactionRecord::setMembership_Id()
     * @uses TransactionRecord::setInvoice_Id()
     * @uses TransactionRecord::setTransactionDate()
     * @uses TransactionRecord::setForm_Id()
     * @uses TransactionRecord::setFormView_Id()
     * @uses TransactionRecord::setAmount()
     * @uses TransactionRecord::setTaxDeductibleAmount()
     * @uses TransactionRecord::setTicketSaleAmount()
     * @uses TransactionRecord::setConfirmed()
     * @uses TransactionRecord::setPromo_Id()
     * @uses TransactionRecord::setPromoCode_Id()
     * @uses TransactionRecord::setMakeAnonymous()
     * @uses TransactionRecord::setHideAmountOnline()
     * @uses TransactionRecord::setIsRefunded()
     * @uses TransactionRecord::setRefundedTransaction_Id()
     * @uses TransactionRecord::setTransactionBatch_Id()
     * @uses TransactionRecord::setContact()
     * @uses TransactionRecord::setCategory()
     * @uses TransactionRecord::setPaymentMethod()
     * @uses TransactionRecord::setContactInfo()
     * @uses TransactionRecord::setBillingDetail()
     * @uses TransactionRecord::setRelatedOrganization()
     * @uses TransactionRecord::setElectronicTransactionType()
     * @uses TransactionRecord::setAttribution()
     * @uses TransactionRecord::setDisplayNameOnlineAs()
     * @uses TransactionRecord::setCheckNumber()
     * @uses TransactionRecord::setPaymentResultCode()
     * @uses TransactionRecord::setPaymentResultMessage()
     * @uses TransactionRecord::setCreditCardNumberLastFour()
     * @uses TransactionRecord::setAchAccountNumberLastFour()
     * @param int $sustainer_Id
     * @param int $pledge_Id
     * @param int $membership_Id
     * @param int $invoice_Id
     * @param string $transactionDate
     * @param int $form_Id
     * @param int $formView_Id
     * @param float $amount
     * @param float $taxDeductibleAmount
     * @param float $ticketSaleAmount
     * @param bool $confirmed
     * @param int $promo_Id
     * @param int $promoCode_Id
     * @param bool $makeAnonymous
     * @param bool $hideAmountOnline
     * @param bool $isRefunded
     * @param int $refundedTransaction_Id
     * @param int $transactionBatch_Id
     * @param \StructType\ContactSummary $contact
     * @param \StructType\TransactionCategory $category
     * @param \StructType\PaymentMethod $paymentMethod
     * @param \StructType\CustomerDetail $contactInfo
     * @param \StructType\BillingInfoCollection $billingDetail
     * @param \StructType\OrganizationSummary $relatedOrganization
     * @param \StructType\ElectronicTransactionType $electronicTransactionType
     * @param \StructType\AttributionInfoCollection $attribution
     * @param string $displayNameOnlineAs
     * @param string $checkNumber
     * @param string $paymentResultCode
     * @param string $paymentResultMessage
     * @param string $creditCardNumberLastFour
     * @param string $achAccountNumberLastFour
     */
    public function __construct($sustainer_Id = null, $pledge_Id = null, $membership_Id = null, $invoice_Id = null, $transactionDate = null, $form_Id = null, $formView_Id = null, $amount = null, $taxDeductibleAmount = null, $ticketSaleAmount = null, $confirmed = null, $promo_Id = null, $promoCode_Id = null, $makeAnonymous = null, $hideAmountOnline = null, $isRefunded = null, $refundedTransaction_Id = null, $transactionBatch_Id = null, \StructType\ContactSummary $contact = null, \StructType\TransactionCategory $category = null, \StructType\PaymentMethod $paymentMethod = null, \StructType\CustomerDetail $contactInfo = null, \StructType\BillingInfoCollection $billingDetail = null, \StructType\OrganizationSummary $relatedOrganization = null, \StructType\ElectronicTransactionType $electronicTransactionType = null, \StructType\AttributionInfoCollection $attribution = null, $displayNameOnlineAs = null, $checkNumber = null, $paymentResultCode = null, $paymentResultMessage = null, $creditCardNumberLastFour = null, $achAccountNumberLastFour = null)
    {
        $this
            ->setSustainer_Id($sustainer_Id)
            ->setPledge_Id($pledge_Id)
            ->setMembership_Id($membership_Id)
            ->setInvoice_Id($invoice_Id)
            ->setTransactionDate($transactionDate)
            ->setForm_Id($form_Id)
            ->setFormView_Id($formView_Id)
            ->setAmount($amount)
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setTicketSaleAmount($ticketSaleAmount)
            ->setConfirmed($confirmed)
            ->setPromo_Id($promo_Id)
            ->setPromoCode_Id($promoCode_Id)
            ->setMakeAnonymous($makeAnonymous)
            ->setHideAmountOnline($hideAmountOnline)
            ->setIsRefunded($isRefunded)
            ->setRefundedTransaction_Id($refundedTransaction_Id)
            ->setTransactionBatch_Id($transactionBatch_Id)
            ->setContact($contact)
            ->setCategory($category)
            ->setPaymentMethod($paymentMethod)
            ->setContactInfo($contactInfo)
            ->setBillingDetail($billingDetail)
            ->setRelatedOrganization($relatedOrganization)
            ->setElectronicTransactionType($electronicTransactionType)
            ->setAttribution($attribution)
            ->setDisplayNameOnlineAs($displayNameOnlineAs)
            ->setCheckNumber($checkNumber)
            ->setPaymentResultCode($paymentResultCode)
            ->setPaymentResultMessage($paymentResultMessage)
            ->setCreditCardNumberLastFour($creditCardNumberLastFour)
            ->setAchAccountNumberLastFour($achAccountNumberLastFour);
    }
    /**
     * Get Sustainer_Id value
     * @return int
     */
    public function getSustainer_Id()
    {
        return $this->Sustainer_Id;
    }
    /**
     * Set Sustainer_Id value
     * @param int $sustainer_Id
     * @return \StructType\TransactionRecord
     */
    public function setSustainer_Id($sustainer_Id = null)
    {
        // validation for constraint: int
        if (!is_null($sustainer_Id) && !is_numeric($sustainer_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sustainer_Id)), __LINE__);
        }
        $this->Sustainer_Id = $sustainer_Id;
        return $this;
    }
    /**
     * Get Pledge_Id value
     * @return int
     */
    public function getPledge_Id()
    {
        return $this->Pledge_Id;
    }
    /**
     * Set Pledge_Id value
     * @param int $pledge_Id
     * @return \StructType\TransactionRecord
     */
    public function setPledge_Id($pledge_Id = null)
    {
        // validation for constraint: int
        if (!is_null($pledge_Id) && !is_numeric($pledge_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pledge_Id)), __LINE__);
        }
        $this->Pledge_Id = $pledge_Id;
        return $this;
    }
    /**
     * Get Membership_Id value
     * @return int
     */
    public function getMembership_Id()
    {
        return $this->Membership_Id;
    }
    /**
     * Set Membership_Id value
     * @param int $membership_Id
     * @return \StructType\TransactionRecord
     */
    public function setMembership_Id($membership_Id = null)
    {
        // validation for constraint: int
        if (!is_null($membership_Id) && !is_numeric($membership_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($membership_Id)), __LINE__);
        }
        $this->Membership_Id = $membership_Id;
        return $this;
    }
    /**
     * Get Invoice_Id value
     * @return int
     */
    public function getInvoice_Id()
    {
        return $this->Invoice_Id;
    }
    /**
     * Set Invoice_Id value
     * @param int $invoice_Id
     * @return \StructType\TransactionRecord
     */
    public function setInvoice_Id($invoice_Id = null)
    {
        // validation for constraint: int
        if (!is_null($invoice_Id) && !is_numeric($invoice_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoice_Id)), __LINE__);
        }
        $this->Invoice_Id = $invoice_Id;
        return $this;
    }
    /**
     * Get TransactionDate value
     * @return string
     */
    public function getTransactionDate()
    {
        return $this->TransactionDate;
    }
    /**
     * Set TransactionDate value
     * @param string $transactionDate
     * @return \StructType\TransactionRecord
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDate)), __LINE__);
        }
        $this->TransactionDate = $transactionDate;
        return $this;
    }
    /**
     * Get Form_Id value
     * @return int
     */
    public function getForm_Id()
    {
        return $this->Form_Id;
    }
    /**
     * Set Form_Id value
     * @param int $form_Id
     * @return \StructType\TransactionRecord
     */
    public function setForm_Id($form_Id = null)
    {
        // validation for constraint: int
        if (!is_null($form_Id) && !is_numeric($form_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($form_Id)), __LINE__);
        }
        $this->Form_Id = $form_Id;
        return $this;
    }
    /**
     * Get FormView_Id value
     * @return int
     */
    public function getFormView_Id()
    {
        return $this->FormView_Id;
    }
    /**
     * Set FormView_Id value
     * @param int $formView_Id
     * @return \StructType\TransactionRecord
     */
    public function setFormView_Id($formView_Id = null)
    {
        // validation for constraint: int
        if (!is_null($formView_Id) && !is_numeric($formView_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formView_Id)), __LINE__);
        }
        $this->FormView_Id = $formView_Id;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TransactionRecord
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\TransactionRecord
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get TicketSaleAmount value
     * @return float
     */
    public function getTicketSaleAmount()
    {
        return $this->TicketSaleAmount;
    }
    /**
     * Set TicketSaleAmount value
     * @param float $ticketSaleAmount
     * @return \StructType\TransactionRecord
     */
    public function setTicketSaleAmount($ticketSaleAmount = null)
    {
        $this->TicketSaleAmount = $ticketSaleAmount;
        return $this;
    }
    /**
     * Get Confirmed value
     * @return bool
     */
    public function getConfirmed()
    {
        return $this->Confirmed;
    }
    /**
     * Set Confirmed value
     * @param bool $confirmed
     * @return \StructType\TransactionRecord
     */
    public function setConfirmed($confirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmed) && !is_bool($confirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($confirmed)), __LINE__);
        }
        $this->Confirmed = $confirmed;
        return $this;
    }
    /**
     * Get Promo_Id value
     * @return int
     */
    public function getPromo_Id()
    {
        return $this->Promo_Id;
    }
    /**
     * Set Promo_Id value
     * @param int $promo_Id
     * @return \StructType\TransactionRecord
     */
    public function setPromo_Id($promo_Id = null)
    {
        // validation for constraint: int
        if (!is_null($promo_Id) && !is_numeric($promo_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promo_Id)), __LINE__);
        }
        $this->Promo_Id = $promo_Id;
        return $this;
    }
    /**
     * Get PromoCode_Id value
     * @return int
     */
    public function getPromoCode_Id()
    {
        return $this->PromoCode_Id;
    }
    /**
     * Set PromoCode_Id value
     * @param int $promoCode_Id
     * @return \StructType\TransactionRecord
     */
    public function setPromoCode_Id($promoCode_Id = null)
    {
        // validation for constraint: int
        if (!is_null($promoCode_Id) && !is_numeric($promoCode_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promoCode_Id)), __LINE__);
        }
        $this->PromoCode_Id = $promoCode_Id;
        return $this;
    }
    /**
     * Get MakeAnonymous value
     * @return bool
     */
    public function getMakeAnonymous()
    {
        return $this->MakeAnonymous;
    }
    /**
     * Set MakeAnonymous value
     * @param bool $makeAnonymous
     * @return \StructType\TransactionRecord
     */
    public function setMakeAnonymous($makeAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($makeAnonymous) && !is_bool($makeAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($makeAnonymous)), __LINE__);
        }
        $this->MakeAnonymous = $makeAnonymous;
        return $this;
    }
    /**
     * Get HideAmountOnline value
     * @return bool
     */
    public function getHideAmountOnline()
    {
        return $this->HideAmountOnline;
    }
    /**
     * Set HideAmountOnline value
     * @param bool $hideAmountOnline
     * @return \StructType\TransactionRecord
     */
    public function setHideAmountOnline($hideAmountOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideAmountOnline) && !is_bool($hideAmountOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hideAmountOnline)), __LINE__);
        }
        $this->HideAmountOnline = $hideAmountOnline;
        return $this;
    }
    /**
     * Get IsRefunded value
     * @return bool
     */
    public function getIsRefunded()
    {
        return $this->IsRefunded;
    }
    /**
     * Set IsRefunded value
     * @param bool $isRefunded
     * @return \StructType\TransactionRecord
     */
    public function setIsRefunded($isRefunded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefunded) && !is_bool($isRefunded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRefunded)), __LINE__);
        }
        $this->IsRefunded = $isRefunded;
        return $this;
    }
    /**
     * Get RefundedTransaction_Id value
     * @return int
     */
    public function getRefundedTransaction_Id()
    {
        return $this->RefundedTransaction_Id;
    }
    /**
     * Set RefundedTransaction_Id value
     * @param int $refundedTransaction_Id
     * @return \StructType\TransactionRecord
     */
    public function setRefundedTransaction_Id($refundedTransaction_Id = null)
    {
        // validation for constraint: int
        if (!is_null($refundedTransaction_Id) && !is_numeric($refundedTransaction_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refundedTransaction_Id)), __LINE__);
        }
        $this->RefundedTransaction_Id = $refundedTransaction_Id;
        return $this;
    }
    /**
     * Get TransactionBatch_Id value
     * @return int
     */
    public function getTransactionBatch_Id()
    {
        return $this->TransactionBatch_Id;
    }
    /**
     * Set TransactionBatch_Id value
     * @param int $transactionBatch_Id
     * @return \StructType\TransactionRecord
     */
    public function setTransactionBatch_Id($transactionBatch_Id = null)
    {
        // validation for constraint: int
        if (!is_null($transactionBatch_Id) && !is_numeric($transactionBatch_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionBatch_Id)), __LINE__);
        }
        $this->TransactionBatch_Id = $transactionBatch_Id;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\TransactionRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\TransactionCategory|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\TransactionCategory $category
     * @return \StructType\TransactionRecord
     */
    public function setCategory(\StructType\TransactionCategory $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\PaymentMethod|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\PaymentMethod $paymentMethod
     * @return \StructType\TransactionRecord
     */
    public function setPaymentMethod(\StructType\PaymentMethod $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\CustomerDetail|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \StructType\CustomerDetail $contactInfo
     * @return \StructType\TransactionRecord
     */
    public function setContactInfo(\StructType\CustomerDetail $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get BillingDetail value
     * @return \StructType\BillingInfoCollection|null
     */
    public function getBillingDetail()
    {
        return $this->BillingDetail;
    }
    /**
     * Set BillingDetail value
     * @param \StructType\BillingInfoCollection $billingDetail
     * @return \StructType\TransactionRecord
     */
    public function setBillingDetail(\StructType\BillingInfoCollection $billingDetail = null)
    {
        $this->BillingDetail = $billingDetail;
        return $this;
    }
    /**
     * Get RelatedOrganization value
     * @return \StructType\OrganizationSummary|null
     */
    public function getRelatedOrganization()
    {
        return $this->RelatedOrganization;
    }
    /**
     * Set RelatedOrganization value
     * @param \StructType\OrganizationSummary $relatedOrganization
     * @return \StructType\TransactionRecord
     */
    public function setRelatedOrganization(\StructType\OrganizationSummary $relatedOrganization = null)
    {
        $this->RelatedOrganization = $relatedOrganization;
        return $this;
    }
    /**
     * Get ElectronicTransactionType value
     * @return \StructType\ElectronicTransactionType|null
     */
    public function getElectronicTransactionType()
    {
        return $this->ElectronicTransactionType;
    }
    /**
     * Set ElectronicTransactionType value
     * @param \StructType\ElectronicTransactionType $electronicTransactionType
     * @return \StructType\TransactionRecord
     */
    public function setElectronicTransactionType(\StructType\ElectronicTransactionType $electronicTransactionType = null)
    {
        $this->ElectronicTransactionType = $electronicTransactionType;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionInfoCollection|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionInfoCollection $attribution
     * @return \StructType\TransactionRecord
     */
    public function setAttribution(\StructType\AttributionInfoCollection $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get DisplayNameOnlineAs value
     * @return string|null
     */
    public function getDisplayNameOnlineAs()
    {
        return $this->DisplayNameOnlineAs;
    }
    /**
     * Set DisplayNameOnlineAs value
     * @param string $displayNameOnlineAs
     * @return \StructType\TransactionRecord
     */
    public function setDisplayNameOnlineAs($displayNameOnlineAs = null)
    {
        // validation for constraint: string
        if (!is_null($displayNameOnlineAs) && !is_string($displayNameOnlineAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayNameOnlineAs)), __LINE__);
        }
        $this->DisplayNameOnlineAs = $displayNameOnlineAs;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\TransactionRecord
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get PaymentResultCode value
     * @return string|null
     */
    public function getPaymentResultCode()
    {
        return $this->PaymentResultCode;
    }
    /**
     * Set PaymentResultCode value
     * @param string $paymentResultCode
     * @return \StructType\TransactionRecord
     */
    public function setPaymentResultCode($paymentResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentResultCode) && !is_string($paymentResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentResultCode)), __LINE__);
        }
        $this->PaymentResultCode = $paymentResultCode;
        return $this;
    }
    /**
     * Get PaymentResultMessage value
     * @return string|null
     */
    public function getPaymentResultMessage()
    {
        return $this->PaymentResultMessage;
    }
    /**
     * Set PaymentResultMessage value
     * @param string $paymentResultMessage
     * @return \StructType\TransactionRecord
     */
    public function setPaymentResultMessage($paymentResultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($paymentResultMessage) && !is_string($paymentResultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentResultMessage)), __LINE__);
        }
        $this->PaymentResultMessage = $paymentResultMessage;
        return $this;
    }
    /**
     * Get CreditCardNumberLastFour value
     * @return string|null
     */
    public function getCreditCardNumberLastFour()
    {
        return $this->CreditCardNumberLastFour;
    }
    /**
     * Set CreditCardNumberLastFour value
     * @param string $creditCardNumberLastFour
     * @return \StructType\TransactionRecord
     */
    public function setCreditCardNumberLastFour($creditCardNumberLastFour = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumberLastFour) && !is_string($creditCardNumberLastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumberLastFour)), __LINE__);
        }
        $this->CreditCardNumberLastFour = $creditCardNumberLastFour;
        return $this;
    }
    /**
     * Get AchAccountNumberLastFour value
     * @return string|null
     */
    public function getAchAccountNumberLastFour()
    {
        return $this->AchAccountNumberLastFour;
    }
    /**
     * Set AchAccountNumberLastFour value
     * @param string $achAccountNumberLastFour
     * @return \StructType\TransactionRecord
     */
    public function setAchAccountNumberLastFour($achAccountNumberLastFour = null)
    {
        // validation for constraint: string
        if (!is_null($achAccountNumberLastFour) && !is_string($achAccountNumberLastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($achAccountNumberLastFour)), __LINE__);
        }
        $this->AchAccountNumberLastFour = $achAccountNumberLastFour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
