<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncReference StructType
 * @subpackage Structs
 */
class SyncReference extends AbstractStructBase
{
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SyncProvider
     */
    public $Provider;
    /**
     * The SyncExternalId
     * @var string
     */
    public $SyncExternalId;
    /**
     * Constructor method for SyncReference
     * @uses SyncReference::setProvider()
     * @uses SyncReference::setSyncExternalId()
     * @param \StructType\SyncProvider $provider
     * @param string $syncExternalId
     */
    public function __construct(\StructType\SyncProvider $provider = null, $syncExternalId = null)
    {
        $this
            ->setProvider($provider)
            ->setSyncExternalId($syncExternalId);
    }
    /**
     * Get Provider value
     * @return \StructType\SyncProvider|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param \StructType\SyncProvider $provider
     * @return \StructType\SyncReference
     */
    public function setProvider(\StructType\SyncProvider $provider = null)
    {
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get SyncExternalId value
     * @return string|null
     */
    public function getSyncExternalId()
    {
        return $this->SyncExternalId;
    }
    /**
     * Set SyncExternalId value
     * @param string $syncExternalId
     * @return \StructType\SyncReference
     */
    public function setSyncExternalId($syncExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($syncExternalId) && !is_string($syncExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncExternalId)), __LINE__);
        }
        $this->SyncExternalId = $syncExternalId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
