<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SustainerAttributionParameters StructType
 * @subpackage Structs
 */
class SustainerAttributionParameters extends AttributionParameters
{
    /**
     * The AttributionMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AttributionMode;
    /**
     * Constructor method for SustainerAttributionParameters
     * @uses SustainerAttributionParameters::setAttributionMode()
     * @param string $attributionMode
     */
    public function __construct($attributionMode = null)
    {
        $this
            ->setAttributionMode($attributionMode);
    }
    /**
     * Get AttributionMode value
     * @return string
     */
    public function getAttributionMode()
    {
        return $this->AttributionMode;
    }
    /**
     * Set AttributionMode value
     * @uses \EnumType\SustainerAttributionModes::valueIsValid()
     * @uses \EnumType\SustainerAttributionModes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributionMode
     * @return \StructType\SustainerAttributionParameters
     */
    public function setAttributionMode($attributionMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SustainerAttributionModes::valueIsValid($attributionMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attributionMode, implode(', ', \EnumType\SustainerAttributionModes::getValidValues())), __LINE__);
        }
        $this->AttributionMode = $attributionMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SustainerAttributionParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
