<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateProvinceDetail StructType
 * @subpackage Structs
 */
class StateProvinceDetail extends MetaDataRecord
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryDetail
     */
    public $Country;
    /**
     * The Abbreviation
     * @var string
     */
    public $Abbreviation;
    /**
     * Constructor method for StateProvinceDetail
     * @uses StateProvinceDetail::setCountry()
     * @uses StateProvinceDetail::setAbbreviation()
     * @param \StructType\CountryDetail $country
     * @param string $abbreviation
     */
    public function __construct(\StructType\CountryDetail $country = null, $abbreviation = null)
    {
        $this
            ->setCountry($country)
            ->setAbbreviation($abbreviation);
    }
    /**
     * Get Country value
     * @return \StructType\CountryDetail|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryDetail $country
     * @return \StructType\StateProvinceDetail
     */
    public function setCountry(\StructType\CountryDetail $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->Abbreviation;
    }
    /**
     * Set Abbreviation value
     * @param string $abbreviation
     * @return \StructType\StateProvinceDetail
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviation)), __LINE__);
        }
        $this->Abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StateProvinceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
