<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundElectronicPaymentParameters StructType
 * @subpackage Structs
 */
class RefundElectronicPaymentParameters extends CreateRecordParameters
{
    /**
     * The Transaction_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Transaction_Id;
    /**
     * Constructor method for RefundElectronicPaymentParameters
     * @uses RefundElectronicPaymentParameters::setTransaction_Id()
     * @param int $transaction_Id
     */
    public function __construct($transaction_Id = null)
    {
        $this
            ->setTransaction_Id($transaction_Id);
    }
    /**
     * Get Transaction_Id value
     * @return int
     */
    public function getTransaction_Id()
    {
        return $this->Transaction_Id;
    }
    /**
     * Set Transaction_Id value
     * @param int $transaction_Id
     * @return \StructType\RefundElectronicPaymentParameters
     */
    public function setTransaction_Id($transaction_Id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_Id) && !is_numeric($transaction_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_Id)), __LINE__);
        }
        $this->Transaction_Id = $transaction_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefundElectronicPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
