<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessAchPaymentParameters StructType
 * @subpackage Structs
 */
class ProcessAchPaymentParameters extends CreateRecordParameters
{
    /**
     * The TaxDeductibleAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TaxDeductibleAmount;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateContactParameters
     */
    public $Contact;
    /**
     * The BankAccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAccountParameters
     */
    public $BankAccountInfo;
    /**
     * The PaymentBillingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentBillingContactParameters
     */
    public $PaymentBillingInfo;
    /**
     * The PrivacyPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentPrivacyPreferenceParameters
     */
    public $PrivacyPreferences;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingEngineParameters
     */
    public $Billing;
    /**
     * The Attribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributionParameters
     */
    public $Attribution;
    /**
     * The SendReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendReceipt;
    /**
     * The UpdateContactActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactUpdateActionParameters
     */
    public $UpdateContactActions;
    /**
     * Constructor method for ProcessAchPaymentParameters
     * @uses ProcessAchPaymentParameters::setTaxDeductibleAmount()
     * @uses ProcessAchPaymentParameters::setAmount()
     * @uses ProcessAchPaymentParameters::setContact()
     * @uses ProcessAchPaymentParameters::setBankAccountInfo()
     * @uses ProcessAchPaymentParameters::setPaymentBillingInfo()
     * @uses ProcessAchPaymentParameters::setPrivacyPreferences()
     * @uses ProcessAchPaymentParameters::setBilling()
     * @uses ProcessAchPaymentParameters::setAttribution()
     * @uses ProcessAchPaymentParameters::setSendReceipt()
     * @uses ProcessAchPaymentParameters::setUpdateContactActions()
     * @param float $taxDeductibleAmount
     * @param float $amount
     * @param \StructType\FindOrCreateContactParameters $contact
     * @param \StructType\BankAccountParameters $bankAccountInfo
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @param \StructType\BillingEngineParameters $billing
     * @param \StructType\AttributionParameters $attribution
     * @param bool $sendReceipt
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     */
    public function __construct($taxDeductibleAmount = null, $amount = null, \StructType\FindOrCreateContactParameters $contact = null, \StructType\BankAccountParameters $bankAccountInfo = null, \StructType\PaymentBillingContactParameters $paymentBillingInfo = null, \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null, \StructType\BillingEngineParameters $billing = null, \StructType\AttributionParameters $attribution = null, $sendReceipt = null, \StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this
            ->setTaxDeductibleAmount($taxDeductibleAmount)
            ->setAmount($amount)
            ->setContact($contact)
            ->setBankAccountInfo($bankAccountInfo)
            ->setPaymentBillingInfo($paymentBillingInfo)
            ->setPrivacyPreferences($privacyPreferences)
            ->setBilling($billing)
            ->setAttribution($attribution)
            ->setSendReceipt($sendReceipt)
            ->setUpdateContactActions($updateContactActions);
    }
    /**
     * Get TaxDeductibleAmount value
     * @return float
     */
    public function getTaxDeductibleAmount()
    {
        return $this->TaxDeductibleAmount;
    }
    /**
     * Set TaxDeductibleAmount value
     * @param float $taxDeductibleAmount
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setTaxDeductibleAmount($taxDeductibleAmount = null)
    {
        $this->TaxDeductibleAmount = $taxDeductibleAmount;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\FindOrCreateContactParameters|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\FindOrCreateContactParameters $contact
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setContact(\StructType\FindOrCreateContactParameters $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get BankAccountInfo value
     * @return \StructType\BankAccountParameters|null
     */
    public function getBankAccountInfo()
    {
        return $this->BankAccountInfo;
    }
    /**
     * Set BankAccountInfo value
     * @param \StructType\BankAccountParameters $bankAccountInfo
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setBankAccountInfo(\StructType\BankAccountParameters $bankAccountInfo = null)
    {
        $this->BankAccountInfo = $bankAccountInfo;
        return $this;
    }
    /**
     * Get PaymentBillingInfo value
     * @return \StructType\PaymentBillingContactParameters|null
     */
    public function getPaymentBillingInfo()
    {
        return $this->PaymentBillingInfo;
    }
    /**
     * Set PaymentBillingInfo value
     * @param \StructType\PaymentBillingContactParameters $paymentBillingInfo
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setPaymentBillingInfo(\StructType\PaymentBillingContactParameters $paymentBillingInfo = null)
    {
        $this->PaymentBillingInfo = $paymentBillingInfo;
        return $this;
    }
    /**
     * Get PrivacyPreferences value
     * @return \StructType\PaymentPrivacyPreferenceParameters|null
     */
    public function getPrivacyPreferences()
    {
        return $this->PrivacyPreferences;
    }
    /**
     * Set PrivacyPreferences value
     * @param \StructType\PaymentPrivacyPreferenceParameters $privacyPreferences
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setPrivacyPreferences(\StructType\PaymentPrivacyPreferenceParameters $privacyPreferences = null)
    {
        $this->PrivacyPreferences = $privacyPreferences;
        return $this;
    }
    /**
     * Get Billing value
     * @return \StructType\BillingEngineParameters|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \StructType\BillingEngineParameters $billing
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setBilling(\StructType\BillingEngineParameters $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get Attribution value
     * @return \StructType\AttributionParameters|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param \StructType\AttributionParameters $attribution
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setAttribution(\StructType\AttributionParameters $attribution = null)
    {
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get SendReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendReceipt()
    {
        return isset($this->SendReceipt) ? $this->SendReceipt : null;
    }
    /**
     * Set SendReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendReceipt
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setSendReceipt($sendReceipt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendReceipt) && !is_bool($sendReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendReceipt)), __LINE__);
        }
        if (is_null($sendReceipt) || (is_array($sendReceipt) && empty($sendReceipt))) {
            unset($this->SendReceipt);
        } else {
            $this->SendReceipt = $sendReceipt;
        }
        return $this;
    }
    /**
     * Get UpdateContactActions value
     * @return \StructType\ContactUpdateActionParameters|null
     */
    public function getUpdateContactActions()
    {
        return $this->UpdateContactActions;
    }
    /**
     * Set UpdateContactActions value
     * @param \StructType\ContactUpdateActionParameters $updateContactActions
     * @return \StructType\ProcessAchPaymentParameters
     */
    public function setUpdateContactActions(\StructType\ContactUpdateActionParameters $updateContactActions = null)
    {
        $this->UpdateContactActions = $updateContactActions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessAchPaymentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
