<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonParameters StructType
 * @subpackage Structs
 */
class PersonParameters extends SubParameters
{
    /**
     * The Prefix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Prefix_Id;
    /**
     * The Suffix_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Suffix_Id;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for PersonParameters
     * @uses PersonParameters::setPrefix_Id()
     * @uses PersonParameters::setSuffix_Id()
     * @uses PersonParameters::setBirthDate()
     * @uses PersonParameters::setGender()
     * @uses PersonParameters::setFirstName()
     * @uses PersonParameters::setMiddleName()
     * @uses PersonParameters::setLastName()
     * @param int $prefix_Id
     * @param int $suffix_Id
     * @param string $birthDate
     * @param string $gender
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct($prefix_Id = null, $suffix_Id = null, $birthDate = null, $gender = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setPrefix_Id($prefix_Id)
            ->setSuffix_Id($suffix_Id)
            ->setBirthDate($birthDate)
            ->setGender($gender)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get Prefix_Id value
     * @return int
     */
    public function getPrefix_Id()
    {
        return $this->Prefix_Id;
    }
    /**
     * Set Prefix_Id value
     * @param int $prefix_Id
     * @return \StructType\PersonParameters
     */
    public function setPrefix_Id($prefix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($prefix_Id) && !is_numeric($prefix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prefix_Id)), __LINE__);
        }
        $this->Prefix_Id = $prefix_Id;
        return $this;
    }
    /**
     * Get Suffix_Id value
     * @return int
     */
    public function getSuffix_Id()
    {
        return $this->Suffix_Id;
    }
    /**
     * Set Suffix_Id value
     * @param int $suffix_Id
     * @return \StructType\PersonParameters
     */
    public function setSuffix_Id($suffix_Id = null)
    {
        // validation for constraint: int
        if (!is_null($suffix_Id) && !is_numeric($suffix_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suffix_Id)), __LINE__);
        }
        $this->Suffix_Id = $suffix_Id;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\PersonParameters
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Genders::valueIsValid()
     * @uses \EnumType\Genders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\PersonParameters
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Genders::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Genders::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\PersonParameters
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\PersonParameters
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\PersonParameters
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
