<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonDetail StructType
 * @subpackage Structs
 */
class PersonDetail extends DependentMetaData
{
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The DeceasedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeceasedDate;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Gender;
    /**
     * The Deceased
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Deceased;
    /**
     * The LanguagePreference
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LanguagePreference;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonTitle
     */
    public $Title;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonNamePrefix
     */
    public $Prefix;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonNameSuffix
     */
    public $Suffix;
    /**
     * The NickName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NickName;
    /**
     * The MaritalStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MaritalStatus
     */
    public $MaritalStatus;
    /**
     * Constructor method for PersonDetail
     * @uses PersonDetail::setBirthDate()
     * @uses PersonDetail::setDeceasedDate()
     * @uses PersonDetail::setGender()
     * @uses PersonDetail::setDeceased()
     * @uses PersonDetail::setLanguagePreference()
     * @uses PersonDetail::setTitle()
     * @uses PersonDetail::setPrefix()
     * @uses PersonDetail::setFirstName()
     * @uses PersonDetail::setMiddleName()
     * @uses PersonDetail::setLastName()
     * @uses PersonDetail::setSuffix()
     * @uses PersonDetail::setNickName()
     * @uses PersonDetail::setMaritalStatus()
     * @param string $birthDate
     * @param string $deceasedDate
     * @param string $gender
     * @param bool $deceased
     * @param string $languagePreference
     * @param \StructType\PersonTitle $title
     * @param \StructType\PersonNamePrefix $prefix
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param \StructType\PersonNameSuffix $suffix
     * @param string $nickName
     * @param \StructType\MaritalStatus $maritalStatus
     */
    public function __construct($birthDate = null, $deceasedDate = null, $gender = null, $deceased = null, $languagePreference = null, \StructType\PersonTitle $title = null, \StructType\PersonNamePrefix $prefix = null, $firstName = null, $middleName = null, $lastName = null, \StructType\PersonNameSuffix $suffix = null, $nickName = null, \StructType\MaritalStatus $maritalStatus = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setDeceasedDate($deceasedDate)
            ->setGender($gender)
            ->setDeceased($deceased)
            ->setLanguagePreference($languagePreference)
            ->setTitle($title)
            ->setPrefix($prefix)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setSuffix($suffix)
            ->setNickName($nickName)
            ->setMaritalStatus($maritalStatus);
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\PersonDetail
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get DeceasedDate value
     * @return string
     */
    public function getDeceasedDate()
    {
        return $this->DeceasedDate;
    }
    /**
     * Set DeceasedDate value
     * @param string $deceasedDate
     * @return \StructType\PersonDetail
     */
    public function setDeceasedDate($deceasedDate = null)
    {
        // validation for constraint: string
        if (!is_null($deceasedDate) && !is_string($deceasedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deceasedDate)), __LINE__);
        }
        $this->DeceasedDate = $deceasedDate;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\Genders::valueIsValid()
     * @uses \EnumType\Genders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\PersonDetail
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Genders::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \EnumType\Genders::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \StructType\PersonDetail
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LanguagePreference value
     * @return string
     */
    public function getLanguagePreference()
    {
        return $this->LanguagePreference;
    }
    /**
     * Set LanguagePreference value
     * @uses \EnumType\LanguagePreferences::valueIsValid()
     * @uses \EnumType\LanguagePreferences::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $languagePreference
     * @return \StructType\PersonDetail
     */
    public function setLanguagePreference($languagePreference = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguagePreferences::valueIsValid($languagePreference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $languagePreference, implode(', ', \EnumType\LanguagePreferences::getValidValues())), __LINE__);
        }
        $this->LanguagePreference = $languagePreference;
        return $this;
    }
    /**
     * Get Title value
     * @return \StructType\PersonTitle|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param \StructType\PersonTitle $title
     * @return \StructType\PersonDetail
     */
    public function setTitle(\StructType\PersonTitle $title = null)
    {
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Prefix value
     * @return \StructType\PersonNamePrefix|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param \StructType\PersonNamePrefix $prefix
     * @return \StructType\PersonDetail
     */
    public function setPrefix(\StructType\PersonNamePrefix $prefix = null)
    {
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\PersonDetail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\PersonDetail
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\PersonDetail
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Suffix value
     * @return \StructType\PersonNameSuffix|null
     */
    public function getSuffix()
    {
        return $this->Suffix;
    }
    /**
     * Set Suffix value
     * @param \StructType\PersonNameSuffix $suffix
     * @return \StructType\PersonDetail
     */
    public function setSuffix(\StructType\PersonNameSuffix $suffix = null)
    {
        $this->Suffix = $suffix;
        return $this;
    }
    /**
     * Get NickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->NickName;
    }
    /**
     * Set NickName value
     * @param string $nickName
     * @return \StructType\PersonDetail
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nickName)), __LINE__);
        }
        $this->NickName = $nickName;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return \StructType\MaritalStatus|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param \StructType\MaritalStatus $maritalStatus
     * @return \StructType\PersonDetail
     */
    public function setMaritalStatus(\StructType\MaritalStatus $maritalStatus = null)
    {
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
