<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeerToPeerTeamRecord StructType
 * @subpackage Structs
 */
class PeerToPeerTeamRecord extends DataRecord
{
    /**
     * The Goal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Goal;
    /**
     * The AmountRaised
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountRaised;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Microsite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PeerToPeerMicrositeDetail
     */
    public $Microsite;
    /**
     * The Captain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Captain;
    /**
     * The TeamName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TeamName;
    /**
     * Constructor method for PeerToPeerTeamRecord
     * @uses PeerToPeerTeamRecord::setGoal()
     * @uses PeerToPeerTeamRecord::setAmountRaised()
     * @uses PeerToPeerTeamRecord::setActive()
     * @uses PeerToPeerTeamRecord::setMicrosite()
     * @uses PeerToPeerTeamRecord::setCaptain()
     * @uses PeerToPeerTeamRecord::setTeamName()
     * @param float $goal
     * @param float $amountRaised
     * @param bool $active
     * @param \StructType\PeerToPeerMicrositeDetail $microsite
     * @param \StructType\ContactSummary $captain
     * @param string $teamName
     */
    public function __construct($goal = null, $amountRaised = null, $active = null, \StructType\PeerToPeerMicrositeDetail $microsite = null, \StructType\ContactSummary $captain = null, $teamName = null)
    {
        $this
            ->setGoal($goal)
            ->setAmountRaised($amountRaised)
            ->setActive($active)
            ->setMicrosite($microsite)
            ->setCaptain($captain)
            ->setTeamName($teamName);
    }
    /**
     * Get Goal value
     * @return float
     */
    public function getGoal()
    {
        return $this->Goal;
    }
    /**
     * Set Goal value
     * @param float $goal
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setGoal($goal = null)
    {
        $this->Goal = $goal;
        return $this;
    }
    /**
     * Get AmountRaised value
     * @return float
     */
    public function getAmountRaised()
    {
        return $this->AmountRaised;
    }
    /**
     * Set AmountRaised value
     * @param float $amountRaised
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setAmountRaised($amountRaised = null)
    {
        $this->AmountRaised = $amountRaised;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Microsite value
     * @return \StructType\PeerToPeerMicrositeDetail|null
     */
    public function getMicrosite()
    {
        return $this->Microsite;
    }
    /**
     * Set Microsite value
     * @param \StructType\PeerToPeerMicrositeDetail $microsite
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setMicrosite(\StructType\PeerToPeerMicrositeDetail $microsite = null)
    {
        $this->Microsite = $microsite;
        return $this;
    }
    /**
     * Get Captain value
     * @return \StructType\ContactSummary|null
     */
    public function getCaptain()
    {
        return $this->Captain;
    }
    /**
     * Set Captain value
     * @param \StructType\ContactSummary $captain
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setCaptain(\StructType\ContactSummary $captain = null)
    {
        $this->Captain = $captain;
        return $this;
    }
    /**
     * Get TeamName value
     * @return string|null
     */
    public function getTeamName()
    {
        return $this->TeamName;
    }
    /**
     * Set TeamName value
     * @param string $teamName
     * @return \StructType\PeerToPeerTeamRecord
     */
    public function setTeamName($teamName = null)
    {
        // validation for constraint: string
        if (!is_null($teamName) && !is_string($teamName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($teamName)), __LINE__);
        }
        $this->TeamName = $teamName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeerToPeerTeamRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
