<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptInListContactRecord StructType
 * @subpackage Structs
 */
class OptInListContactRecord extends DataRecord
{
    /**
     * The DateOptedOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOptedOut;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The DateOptedIn
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DateOptedIn;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The OptInList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OptInList
     */
    public $OptInList;
    /**
     * Constructor method for OptInListContactRecord
     * @uses OptInListContactRecord::setDateOptedOut()
     * @uses OptInListContactRecord::setStatus()
     * @uses OptInListContactRecord::setDateOptedIn()
     * @uses OptInListContactRecord::setContact()
     * @uses OptInListContactRecord::setOptInList()
     * @param string $dateOptedOut
     * @param string $status
     * @param string $dateOptedIn
     * @param \StructType\ContactSummary $contact
     * @param \StructType\OptInList $optInList
     */
    public function __construct($dateOptedOut = null, $status = null, $dateOptedIn = null, \StructType\ContactSummary $contact = null, \StructType\OptInList $optInList = null)
    {
        $this
            ->setDateOptedOut($dateOptedOut)
            ->setStatus($status)
            ->setDateOptedIn($dateOptedIn)
            ->setContact($contact)
            ->setOptInList($optInList);
    }
    /**
     * Get DateOptedOut value
     * @return string
     */
    public function getDateOptedOut()
    {
        return $this->DateOptedOut;
    }
    /**
     * Set DateOptedOut value
     * @param string $dateOptedOut
     * @return \StructType\OptInListContactRecord
     */
    public function setDateOptedOut($dateOptedOut = null)
    {
        // validation for constraint: string
        if (!is_null($dateOptedOut) && !is_string($dateOptedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOptedOut)), __LINE__);
        }
        $this->DateOptedOut = $dateOptedOut;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\OptInListStatuses::valueIsValid()
     * @uses \EnumType\OptInListStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\OptInListContactRecord
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OptInListStatuses::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\OptInListStatuses::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DateOptedIn value
     * @return string
     */
    public function getDateOptedIn()
    {
        return $this->DateOptedIn;
    }
    /**
     * Set DateOptedIn value
     * @param string $dateOptedIn
     * @return \StructType\OptInListContactRecord
     */
    public function setDateOptedIn($dateOptedIn = null)
    {
        // validation for constraint: string
        if (!is_null($dateOptedIn) && !is_string($dateOptedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOptedIn)), __LINE__);
        }
        $this->DateOptedIn = $dateOptedIn;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\OptInListContactRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get OptInList value
     * @return \StructType\OptInList|null
     */
    public function getOptInList()
    {
        return $this->OptInList;
    }
    /**
     * Set OptInList value
     * @param \StructType\OptInList $optInList
     * @return \StructType\OptInListContactRecord
     */
    public function setOptInList(\StructType\OptInList $optInList = null)
    {
        $this->OptInList = $optInList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OptInListContactRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
