<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityTypeTrackStep StructType
 * @subpackage Structs
 */
class OpportunityTypeTrackStep extends MetaDataRecord
{
    /**
     * The OrderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The CloseProbability
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CloseProbability;
    /**
     * The OpportunityTypeTrack
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityTypeTrack
     */
    public $OpportunityTypeTrack;
    /**
     * The StepStage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityStage
     */
    public $StepStage;
    /**
     * The ActivityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityType
     */
    public $ActivityType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for OpportunityTypeTrackStep
     * @uses OpportunityTypeTrackStep::setOrderNumber()
     * @uses OpportunityTypeTrackStep::setCloseProbability()
     * @uses OpportunityTypeTrackStep::setOpportunityTypeTrack()
     * @uses OpportunityTypeTrackStep::setStepStage()
     * @uses OpportunityTypeTrackStep::setActivityType()
     * @uses OpportunityTypeTrackStep::setDescription()
     * @param int $orderNumber
     * @param float $closeProbability
     * @param \StructType\OpportunityTypeTrack $opportunityTypeTrack
     * @param \StructType\OpportunityStage $stepStage
     * @param \StructType\ActivityType $activityType
     * @param string $description
     */
    public function __construct($orderNumber = null, $closeProbability = null, \StructType\OpportunityTypeTrack $opportunityTypeTrack = null, \StructType\OpportunityStage $stepStage = null, \StructType\ActivityType $activityType = null, $description = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setCloseProbability($closeProbability)
            ->setOpportunityTypeTrack($opportunityTypeTrack)
            ->setStepStage($stepStage)
            ->setActivityType($activityType)
            ->setDescription($description);
    }
    /**
     * Get OrderNumber value
     * @return int
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param int $orderNumber
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !is_numeric($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get CloseProbability value
     * @return float
     */
    public function getCloseProbability()
    {
        return $this->CloseProbability;
    }
    /**
     * Set CloseProbability value
     * @param float $closeProbability
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setCloseProbability($closeProbability = null)
    {
        $this->CloseProbability = $closeProbability;
        return $this;
    }
    /**
     * Get OpportunityTypeTrack value
     * @return \StructType\OpportunityTypeTrack|null
     */
    public function getOpportunityTypeTrack()
    {
        return $this->OpportunityTypeTrack;
    }
    /**
     * Set OpportunityTypeTrack value
     * @param \StructType\OpportunityTypeTrack $opportunityTypeTrack
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setOpportunityTypeTrack(\StructType\OpportunityTypeTrack $opportunityTypeTrack = null)
    {
        $this->OpportunityTypeTrack = $opportunityTypeTrack;
        return $this;
    }
    /**
     * Get StepStage value
     * @return \StructType\OpportunityStage|null
     */
    public function getStepStage()
    {
        return $this->StepStage;
    }
    /**
     * Set StepStage value
     * @param \StructType\OpportunityStage $stepStage
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setStepStage(\StructType\OpportunityStage $stepStage = null)
    {
        $this->StepStage = $stepStage;
        return $this;
    }
    /**
     * Get ActivityType value
     * @return \StructType\ActivityType|null
     */
    public function getActivityType()
    {
        return $this->ActivityType;
    }
    /**
     * Set ActivityType value
     * @param \StructType\ActivityType $activityType
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setActivityType(\StructType\ActivityType $activityType = null)
    {
        $this->ActivityType = $activityType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OpportunityTypeTrackStep
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpportunityTypeTrackStep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
