<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityTypeTrack StructType
 * @subpackage Structs
 */
class OpportunityTypeTrack extends MetaDataRecord
{
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The OpportunityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityType
     */
    public $OpportunityType;
    /**
     * The OpportunityTypeNameVerbose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpportunityTypeNameVerbose;
    /**
     * Constructor method for OpportunityTypeTrack
     * @uses OpportunityTypeTrack::setIsActive()
     * @uses OpportunityTypeTrack::setDescription()
     * @uses OpportunityTypeTrack::setOpportunityType()
     * @uses OpportunityTypeTrack::setOpportunityTypeNameVerbose()
     * @param bool $isActive
     * @param string $description
     * @param \StructType\OpportunityType $opportunityType
     * @param string $opportunityTypeNameVerbose
     */
    public function __construct($isActive = null, $description = null, \StructType\OpportunityType $opportunityType = null, $opportunityTypeNameVerbose = null)
    {
        $this
            ->setIsActive($isActive)
            ->setDescription($description)
            ->setOpportunityType($opportunityType)
            ->setOpportunityTypeNameVerbose($opportunityTypeNameVerbose);
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\OpportunityTypeTrack
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OpportunityTypeTrack
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get OpportunityType value
     * @return \StructType\OpportunityType|null
     */
    public function getOpportunityType()
    {
        return $this->OpportunityType;
    }
    /**
     * Set OpportunityType value
     * @param \StructType\OpportunityType $opportunityType
     * @return \StructType\OpportunityTypeTrack
     */
    public function setOpportunityType(\StructType\OpportunityType $opportunityType = null)
    {
        $this->OpportunityType = $opportunityType;
        return $this;
    }
    /**
     * Get OpportunityTypeNameVerbose value
     * @return string|null
     */
    public function getOpportunityTypeNameVerbose()
    {
        return $this->OpportunityTypeNameVerbose;
    }
    /**
     * Set OpportunityTypeNameVerbose value
     * @param string $opportunityTypeNameVerbose
     * @return \StructType\OpportunityTypeTrack
     */
    public function setOpportunityTypeNameVerbose($opportunityTypeNameVerbose = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityTypeNameVerbose) && !is_string($opportunityTypeNameVerbose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opportunityTypeNameVerbose)), __LINE__);
        }
        $this->OpportunityTypeNameVerbose = $opportunityTypeNameVerbose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpportunityTypeTrack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
