<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityRecord StructType
 * @subpackage Structs
 */
class OpportunityRecord extends NamedDataRecord
{
    /**
     * The EstimatedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EstimatedValue;
    /**
     * The EstimatedCloseDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EstimatedCloseDate;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The OwnerPrimaryContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $OwnerPrimaryContact;
    /**
     * The TargetPrimaryContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $TargetPrimaryContact;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityStatus
     */
    public $Status;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityPriority
     */
    public $Priority;
    /**
     * The Track
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityTypeTrack
     */
    public $Track;
    /**
     * The TrackCurrentStep
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpportunityTypeTrackStep
     */
    public $TrackCurrentStep;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOpportunityContactRecord
     */
    public $Contacts;
    /**
     * The Solicitors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOpportunitySolicitorRecord
     */
    public $Solicitors;
    /**
     * Constructor method for OpportunityRecord
     * @uses OpportunityRecord::setEstimatedValue()
     * @uses OpportunityRecord::setEstimatedCloseDate()
     * @uses OpportunityRecord::setActive()
     * @uses OpportunityRecord::setOwnerPrimaryContact()
     * @uses OpportunityRecord::setTargetPrimaryContact()
     * @uses OpportunityRecord::setStatus()
     * @uses OpportunityRecord::setPriority()
     * @uses OpportunityRecord::setTrack()
     * @uses OpportunityRecord::setTrackCurrentStep()
     * @uses OpportunityRecord::setDescription()
     * @uses OpportunityRecord::setContacts()
     * @uses OpportunityRecord::setSolicitors()
     * @param float $estimatedValue
     * @param string $estimatedCloseDate
     * @param bool $active
     * @param \StructType\ContactSummary $ownerPrimaryContact
     * @param \StructType\ContactSummary $targetPrimaryContact
     * @param \StructType\OpportunityStatus $status
     * @param \StructType\OpportunityPriority $priority
     * @param \StructType\OpportunityTypeTrack $track
     * @param \StructType\OpportunityTypeTrackStep $trackCurrentStep
     * @param string $description
     * @param \ArrayType\ArrayOfOpportunityContactRecord $contacts
     * @param \ArrayType\ArrayOfOpportunitySolicitorRecord $solicitors
     */
    public function __construct($estimatedValue = null, $estimatedCloseDate = null, $active = null, \StructType\ContactSummary $ownerPrimaryContact = null, \StructType\ContactSummary $targetPrimaryContact = null, \StructType\OpportunityStatus $status = null, \StructType\OpportunityPriority $priority = null, \StructType\OpportunityTypeTrack $track = null, \StructType\OpportunityTypeTrackStep $trackCurrentStep = null, $description = null, \ArrayType\ArrayOfOpportunityContactRecord $contacts = null, \ArrayType\ArrayOfOpportunitySolicitorRecord $solicitors = null)
    {
        $this
            ->setEstimatedValue($estimatedValue)
            ->setEstimatedCloseDate($estimatedCloseDate)
            ->setActive($active)
            ->setOwnerPrimaryContact($ownerPrimaryContact)
            ->setTargetPrimaryContact($targetPrimaryContact)
            ->setStatus($status)
            ->setPriority($priority)
            ->setTrack($track)
            ->setTrackCurrentStep($trackCurrentStep)
            ->setDescription($description)
            ->setContacts($contacts)
            ->setSolicitors($solicitors);
    }
    /**
     * Get EstimatedValue value
     * @return float
     */
    public function getEstimatedValue()
    {
        return $this->EstimatedValue;
    }
    /**
     * Set EstimatedValue value
     * @param float $estimatedValue
     * @return \StructType\OpportunityRecord
     */
    public function setEstimatedValue($estimatedValue = null)
    {
        $this->EstimatedValue = $estimatedValue;
        return $this;
    }
    /**
     * Get EstimatedCloseDate value
     * @return string
     */
    public function getEstimatedCloseDate()
    {
        return $this->EstimatedCloseDate;
    }
    /**
     * Set EstimatedCloseDate value
     * @param string $estimatedCloseDate
     * @return \StructType\OpportunityRecord
     */
    public function setEstimatedCloseDate($estimatedCloseDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedCloseDate) && !is_string($estimatedCloseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedCloseDate)), __LINE__);
        }
        $this->EstimatedCloseDate = $estimatedCloseDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\OpportunityRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get OwnerPrimaryContact value
     * @return \StructType\ContactSummary|null
     */
    public function getOwnerPrimaryContact()
    {
        return $this->OwnerPrimaryContact;
    }
    /**
     * Set OwnerPrimaryContact value
     * @param \StructType\ContactSummary $ownerPrimaryContact
     * @return \StructType\OpportunityRecord
     */
    public function setOwnerPrimaryContact(\StructType\ContactSummary $ownerPrimaryContact = null)
    {
        $this->OwnerPrimaryContact = $ownerPrimaryContact;
        return $this;
    }
    /**
     * Get TargetPrimaryContact value
     * @return \StructType\ContactSummary|null
     */
    public function getTargetPrimaryContact()
    {
        return $this->TargetPrimaryContact;
    }
    /**
     * Set TargetPrimaryContact value
     * @param \StructType\ContactSummary $targetPrimaryContact
     * @return \StructType\OpportunityRecord
     */
    public function setTargetPrimaryContact(\StructType\ContactSummary $targetPrimaryContact = null)
    {
        $this->TargetPrimaryContact = $targetPrimaryContact;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\OpportunityStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\OpportunityStatus $status
     * @return \StructType\OpportunityRecord
     */
    public function setStatus(\StructType\OpportunityStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Priority value
     * @return \StructType\OpportunityPriority|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param \StructType\OpportunityPriority $priority
     * @return \StructType\OpportunityRecord
     */
    public function setPriority(\StructType\OpportunityPriority $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Track value
     * @return \StructType\OpportunityTypeTrack|null
     */
    public function getTrack()
    {
        return $this->Track;
    }
    /**
     * Set Track value
     * @param \StructType\OpportunityTypeTrack $track
     * @return \StructType\OpportunityRecord
     */
    public function setTrack(\StructType\OpportunityTypeTrack $track = null)
    {
        $this->Track = $track;
        return $this;
    }
    /**
     * Get TrackCurrentStep value
     * @return \StructType\OpportunityTypeTrackStep|null
     */
    public function getTrackCurrentStep()
    {
        return $this->TrackCurrentStep;
    }
    /**
     * Set TrackCurrentStep value
     * @param \StructType\OpportunityTypeTrackStep $trackCurrentStep
     * @return \StructType\OpportunityRecord
     */
    public function setTrackCurrentStep(\StructType\OpportunityTypeTrackStep $trackCurrentStep = null)
    {
        $this->TrackCurrentStep = $trackCurrentStep;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OpportunityRecord
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Contacts value
     * @return \ArrayType\ArrayOfOpportunityContactRecord|null
     */
    public function getContacts()
    {
        return $this->Contacts;
    }
    /**
     * Set Contacts value
     * @param \ArrayType\ArrayOfOpportunityContactRecord $contacts
     * @return \StructType\OpportunityRecord
     */
    public function setContacts(\ArrayType\ArrayOfOpportunityContactRecord $contacts = null)
    {
        $this->Contacts = $contacts;
        return $this;
    }
    /**
     * Get Solicitors value
     * @return \ArrayType\ArrayOfOpportunitySolicitorRecord|null
     */
    public function getSolicitors()
    {
        return $this->Solicitors;
    }
    /**
     * Set Solicitors value
     * @param \ArrayType\ArrayOfOpportunitySolicitorRecord $solicitors
     * @return \StructType\OpportunityRecord
     */
    public function setSolicitors(\ArrayType\ArrayOfOpportunitySolicitorRecord $solicitors = null)
    {
        $this->Solicitors = $solicitors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpportunityRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
