<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoteRecord StructType
 * @subpackage Structs
 */
class NoteRecord extends DataRecord
{
    /**
     * The CreatedByContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CreatedByContact_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Contact_Id;
    /**
     * The Transaction_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Transaction_Id;
    /**
     * The Order_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Order_Id;
    /**
     * The Activity_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Activity_Id;
    /**
     * The Relationship_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Relationship_Id;
    /**
     * The Case_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Case_Id;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NoteType
     */
    public $Type;
    /**
     * The NoteContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteContent;
    /**
     * Constructor method for NoteRecord
     * @uses NoteRecord::setCreatedByContact_Id()
     * @uses NoteRecord::setActive()
     * @uses NoteRecord::setContact_Id()
     * @uses NoteRecord::setTransaction_Id()
     * @uses NoteRecord::setOrder_Id()
     * @uses NoteRecord::setActivity_Id()
     * @uses NoteRecord::setRelationship_Id()
     * @uses NoteRecord::setCase_Id()
     * @uses NoteRecord::setType()
     * @uses NoteRecord::setNoteContent()
     * @param int $createdByContact_Id
     * @param bool $active
     * @param int $contact_Id
     * @param int $transaction_Id
     * @param int $order_Id
     * @param int $activity_Id
     * @param int $relationship_Id
     * @param int $case_Id
     * @param \StructType\NoteType $type
     * @param string $noteContent
     */
    public function __construct($createdByContact_Id = null, $active = null, $contact_Id = null, $transaction_Id = null, $order_Id = null, $activity_Id = null, $relationship_Id = null, $case_Id = null, \StructType\NoteType $type = null, $noteContent = null)
    {
        $this
            ->setCreatedByContact_Id($createdByContact_Id)
            ->setActive($active)
            ->setContact_Id($contact_Id)
            ->setTransaction_Id($transaction_Id)
            ->setOrder_Id($order_Id)
            ->setActivity_Id($activity_Id)
            ->setRelationship_Id($relationship_Id)
            ->setCase_Id($case_Id)
            ->setType($type)
            ->setNoteContent($noteContent);
    }
    /**
     * Get CreatedByContact_Id value
     * @return int
     */
    public function getCreatedByContact_Id()
    {
        return $this->CreatedByContact_Id;
    }
    /**
     * Set CreatedByContact_Id value
     * @param int $createdByContact_Id
     * @return \StructType\NoteRecord
     */
    public function setCreatedByContact_Id($createdByContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($createdByContact_Id) && !is_numeric($createdByContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByContact_Id)), __LINE__);
        }
        $this->CreatedByContact_Id = $createdByContact_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\NoteRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\NoteRecord
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Transaction_Id value
     * @return int
     */
    public function getTransaction_Id()
    {
        return $this->Transaction_Id;
    }
    /**
     * Set Transaction_Id value
     * @param int $transaction_Id
     * @return \StructType\NoteRecord
     */
    public function setTransaction_Id($transaction_Id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_Id) && !is_numeric($transaction_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_Id)), __LINE__);
        }
        $this->Transaction_Id = $transaction_Id;
        return $this;
    }
    /**
     * Get Order_Id value
     * @return int
     */
    public function getOrder_Id()
    {
        return $this->Order_Id;
    }
    /**
     * Set Order_Id value
     * @param int $order_Id
     * @return \StructType\NoteRecord
     */
    public function setOrder_Id($order_Id = null)
    {
        // validation for constraint: int
        if (!is_null($order_Id) && !is_numeric($order_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_Id)), __LINE__);
        }
        $this->Order_Id = $order_Id;
        return $this;
    }
    /**
     * Get Activity_Id value
     * @return int
     */
    public function getActivity_Id()
    {
        return $this->Activity_Id;
    }
    /**
     * Set Activity_Id value
     * @param int $activity_Id
     * @return \StructType\NoteRecord
     */
    public function setActivity_Id($activity_Id = null)
    {
        // validation for constraint: int
        if (!is_null($activity_Id) && !is_numeric($activity_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activity_Id)), __LINE__);
        }
        $this->Activity_Id = $activity_Id;
        return $this;
    }
    /**
     * Get Relationship_Id value
     * @return int
     */
    public function getRelationship_Id()
    {
        return $this->Relationship_Id;
    }
    /**
     * Set Relationship_Id value
     * @param int $relationship_Id
     * @return \StructType\NoteRecord
     */
    public function setRelationship_Id($relationship_Id = null)
    {
        // validation for constraint: int
        if (!is_null($relationship_Id) && !is_numeric($relationship_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relationship_Id)), __LINE__);
        }
        $this->Relationship_Id = $relationship_Id;
        return $this;
    }
    /**
     * Get Case_Id value
     * @return int
     */
    public function getCase_Id()
    {
        return $this->Case_Id;
    }
    /**
     * Set Case_Id value
     * @param int $case_Id
     * @return \StructType\NoteRecord
     */
    public function setCase_Id($case_Id = null)
    {
        // validation for constraint: int
        if (!is_null($case_Id) && !is_numeric($case_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($case_Id)), __LINE__);
        }
        $this->Case_Id = $case_Id;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\NoteType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\NoteType $type
     * @return \StructType\NoteRecord
     */
    public function setType(\StructType\NoteType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get NoteContent value
     * @return string|null
     */
    public function getNoteContent()
    {
        return $this->NoteContent;
    }
    /**
     * Set NoteContent value
     * @param string $noteContent
     * @return \StructType\NoteRecord
     */
    public function setNoteContent($noteContent = null)
    {
        // validation for constraint: string
        if (!is_null($noteContent) && !is_string($noteContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteContent)), __LINE__);
        }
        $this->NoteContent = $noteContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoteRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
