<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeContactParameters StructType
 * @subpackage Structs
 */
class MergeContactParameters extends AbstractStructBase
{
    /**
     * The SurvivingContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SurvivingContact_Id;
    /**
     * The DeleteContact_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DeleteContact_Id;
    /**
     * Constructor method for MergeContactParameters
     * @uses MergeContactParameters::setSurvivingContact_Id()
     * @uses MergeContactParameters::setDeleteContact_Id()
     * @param int $survivingContact_Id
     * @param int $deleteContact_Id
     */
    public function __construct($survivingContact_Id = null, $deleteContact_Id = null)
    {
        $this
            ->setSurvivingContact_Id($survivingContact_Id)
            ->setDeleteContact_Id($deleteContact_Id);
    }
    /**
     * Get SurvivingContact_Id value
     * @return int
     */
    public function getSurvivingContact_Id()
    {
        return $this->SurvivingContact_Id;
    }
    /**
     * Set SurvivingContact_Id value
     * @param int $survivingContact_Id
     * @return \StructType\MergeContactParameters
     */
    public function setSurvivingContact_Id($survivingContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($survivingContact_Id) && !is_numeric($survivingContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($survivingContact_Id)), __LINE__);
        }
        $this->SurvivingContact_Id = $survivingContact_Id;
        return $this;
    }
    /**
     * Get DeleteContact_Id value
     * @return int
     */
    public function getDeleteContact_Id()
    {
        return $this->DeleteContact_Id;
    }
    /**
     * Set DeleteContact_Id value
     * @param int $deleteContact_Id
     * @return \StructType\MergeContactParameters
     */
    public function setDeleteContact_Id($deleteContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($deleteContact_Id) && !is_numeric($deleteContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deleteContact_Id)), __LINE__);
        }
        $this->DeleteContact_Id = $deleteContact_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MergeContactParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
