<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntegrationApiError StructType
 * @subpackage Structs
 */
class IntegrationApiError extends ApiErrorBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * Constructor method for IntegrationApiError
     * @uses IntegrationApiError::setCode()
     * @param string $code
     */
    public function __construct($code = null)
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\IntegrationApiErrorCodes::valueIsValid()
     * @uses \EnumType\IntegrationApiErrorCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\IntegrationApiError
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IntegrationApiErrorCodes::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\IntegrationApiErrorCodes::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IntegrationApiError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
