<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeMessageReturnRecord StructType
 * @subpackage Structs
 */
class InitiativeMessageReturnRecord extends DataRecord
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Reason;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * Constructor method for InitiativeMessageReturnRecord
     * @uses InitiativeMessageReturnRecord::setType()
     * @uses InitiativeMessageReturnRecord::setReason()
     * @uses InitiativeMessageReturnRecord::setContact()
     * @uses InitiativeMessageReturnRecord::setInitiative()
     * @param string $type
     * @param string $reason
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     */
    public function __construct($type = null, $reason = null, \StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null)
    {
        $this
            ->setType($type)
            ->setReason($reason)
            ->setContact($contact)
            ->setInitiative($initiative);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\InitiativeMessageReturnTypes::valueIsValid()
     * @uses \EnumType\InitiativeMessageReturnTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\InitiativeMessageReturnRecord
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeMessageReturnTypes::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\InitiativeMessageReturnTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Reason value
     * @return string
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @uses \EnumType\InitiativeMessageReturnReasons::valueIsValid()
     * @uses \EnumType\InitiativeMessageReturnReasons::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason
     * @return \StructType\InitiativeMessageReturnRecord
     */
    public function setReason($reason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeMessageReturnReasons::valueIsValid($reason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reason, implode(', ', \EnumType\InitiativeMessageReturnReasons::getValidValues())), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeMessageReturnRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeMessageReturnRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeMessageReturnRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
