<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeMessageRecord StructType
 * @subpackage Structs
 */
class InitiativeMessageRecord extends NamedDataRecord
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The MediaChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChannelDetail
     */
    public $MediaChannel;
    /**
     * Constructor method for InitiativeMessageRecord
     * @uses InitiativeMessageRecord::setActive()
     * @uses InitiativeMessageRecord::setMediaChannel()
     * @param bool $active
     * @param \StructType\ChannelDetail $mediaChannel
     */
    public function __construct($active = null, \StructType\ChannelDetail $mediaChannel = null)
    {
        $this
            ->setActive($active)
            ->setMediaChannel($mediaChannel);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\InitiativeMessageRecord
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get MediaChannel value
     * @return \StructType\ChannelDetail|null
     */
    public function getMediaChannel()
    {
        return $this->MediaChannel;
    }
    /**
     * Set MediaChannel value
     * @param \StructType\ChannelDetail $mediaChannel
     * @return \StructType\InitiativeMessageRecord
     */
    public function setMediaChannel(\StructType\ChannelDetail $mediaChannel = null)
    {
        $this->MediaChannel = $mediaChannel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeMessageRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
