<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InitiativeAudienceMemberRecord StructType
 * @subpackage Structs
 */
class InitiativeAudienceMemberRecord extends DataRecord
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Initiative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InitiativeDetail
     */
    public $Initiative;
    /**
     * Constructor method for InitiativeAudienceMemberRecord
     * @uses InitiativeAudienceMemberRecord::setStatus()
     * @uses InitiativeAudienceMemberRecord::setContact()
     * @uses InitiativeAudienceMemberRecord::setInitiative()
     * @param string $status
     * @param \StructType\ContactSummary $contact
     * @param \StructType\InitiativeDetail $initiative
     */
    public function __construct($status = null, \StructType\ContactSummary $contact = null, \StructType\InitiativeDetail $initiative = null)
    {
        $this
            ->setStatus($status)
            ->setContact($contact)
            ->setInitiative($initiative);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\InitiativeAudienceMemberStatuses::valueIsValid()
     * @uses \EnumType\InitiativeAudienceMemberStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\InitiativeAudienceMemberRecord
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InitiativeAudienceMemberStatuses::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\InitiativeAudienceMemberStatuses::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\InitiativeAudienceMemberRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Initiative value
     * @return \StructType\InitiativeDetail|null
     */
    public function getInitiative()
    {
        return $this->Initiative;
    }
    /**
     * Set Initiative value
     * @param \StructType\InitiativeDetail $initiative
     * @return \StructType\InitiativeAudienceMemberRecord
     */
    public function setInitiative(\StructType\InitiativeDetail $initiative = null)
    {
        $this->Initiative = $initiative;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InitiativeAudienceMemberRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
