<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWebsitesQuery StructType
 * @subpackage Structs
 */
class GetWebsitesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Website_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Website_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for GetWebsitesQuery
     * @uses GetWebsitesQuery::setWebsite_Id()
     * @uses GetWebsitesQuery::setContact_Id()
     * @uses GetWebsitesQuery::setURL()
     * @param int $website_Id
     * @param int $contact_Id
     * @param string $uRL
     */
    public function __construct($website_Id = null, $contact_Id = null, $uRL = null)
    {
        $this
            ->setWebsite_Id($website_Id)
            ->setContact_Id($contact_Id)
            ->setURL($uRL);
    }
    /**
     * Get Website_Id value
     * @return int
     */
    public function getWebsite_Id()
    {
        return $this->Website_Id;
    }
    /**
     * Set Website_Id value
     * @param int $website_Id
     * @return \StructType\GetWebsitesQuery
     */
    public function setWebsite_Id($website_Id = null)
    {
        // validation for constraint: int
        if (!is_null($website_Id) && !is_numeric($website_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($website_Id)), __LINE__);
        }
        $this->Website_Id = $website_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetWebsitesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\GetWebsitesQuery
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWebsitesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
