<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWebFormsQuery StructType
 * @subpackage Structs
 */
class GetWebFormsQuery extends DateAdvancedPagingQuery
{
    /**
     * The WebForm_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WebForm_Id;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for GetWebFormsQuery
     * @uses GetWebFormsQuery::setWebForm_Id()
     * @uses GetWebFormsQuery::setActive()
     * @param int $webForm_Id
     * @param bool $active
     */
    public function __construct($webForm_Id = null, $active = null)
    {
        $this
            ->setWebForm_Id($webForm_Id)
            ->setActive($active);
    }
    /**
     * Get WebForm_Id value
     * @return int
     */
    public function getWebForm_Id()
    {
        return $this->WebForm_Id;
    }
    /**
     * Set WebForm_Id value
     * @param int $webForm_Id
     * @return \StructType\GetWebFormsQuery
     */
    public function setWebForm_Id($webForm_Id = null)
    {
        // validation for constraint: int
        if (!is_null($webForm_Id) && !is_numeric($webForm_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($webForm_Id)), __LINE__);
        }
        $this->WebForm_Id = $webForm_Id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\GetWebFormsQuery
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetWebFormsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
