<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTagsQuery StructType
 * @subpackage Structs
 */
class GetTagsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Tag_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Tag_Id;
    /**
     * The TagName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TagName;
    /**
     * Constructor method for GetTagsQuery
     * @uses GetTagsQuery::setTag_Id()
     * @uses GetTagsQuery::setTagName()
     * @param int $tag_Id
     * @param string $tagName
     */
    public function __construct($tag_Id = null, $tagName = null)
    {
        $this
            ->setTag_Id($tag_Id)
            ->setTagName($tagName);
    }
    /**
     * Get Tag_Id value
     * @return int
     */
    public function getTag_Id()
    {
        return $this->Tag_Id;
    }
    /**
     * Set Tag_Id value
     * @param int $tag_Id
     * @return \StructType\GetTagsQuery
     */
    public function setTag_Id($tag_Id = null)
    {
        // validation for constraint: int
        if (!is_null($tag_Id) && !is_numeric($tag_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tag_Id)), __LINE__);
        }
        $this->Tag_Id = $tag_Id;
        return $this;
    }
    /**
     * Get TagName value
     * @return string|null
     */
    public function getTagName()
    {
        return $this->TagName;
    }
    /**
     * Set TagName value
     * @param string $tagName
     * @return \StructType\GetTagsQuery
     */
    public function setTagName($tagName = null)
    {
        // validation for constraint: string
        if (!is_null($tagName) && !is_string($tagName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tagName)), __LINE__);
        }
        $this->TagName = $tagName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTagsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
