<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRelationshipsQuery StructType
 * @subpackage Structs
 */
class GetRelationshipsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Relationship_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Relationship_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * Constructor method for GetRelationshipsQuery
     * @uses GetRelationshipsQuery::setRelationship_Id()
     * @uses GetRelationshipsQuery::setContact_Id()
     * @param int $relationship_Id
     * @param int $contact_Id
     */
    public function __construct($relationship_Id = null, $contact_Id = null)
    {
        $this
            ->setRelationship_Id($relationship_Id)
            ->setContact_Id($contact_Id);
    }
    /**
     * Get Relationship_Id value
     * @return int
     */
    public function getRelationship_Id()
    {
        return $this->Relationship_Id;
    }
    /**
     * Set Relationship_Id value
     * @param int $relationship_Id
     * @return \StructType\GetRelationshipsQuery
     */
    public function setRelationship_Id($relationship_Id = null)
    {
        // validation for constraint: int
        if (!is_null($relationship_Id) && !is_numeric($relationship_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relationship_Id)), __LINE__);
        }
        $this->Relationship_Id = $relationship_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetRelationshipsQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRelationshipsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
