<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGroupsQuery StructType
 * @subpackage Structs
 */
class GetGroupsQuery extends DateAdvancedPagingQuery
{
    /**
     * The Group_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Group_Id;
    /**
     * The GroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * Constructor method for GetGroupsQuery
     * @uses GetGroupsQuery::setGroup_Id()
     * @uses GetGroupsQuery::setGroupName()
     * @param int $group_Id
     * @param string $groupName
     */
    public function __construct($group_Id = null, $groupName = null)
    {
        $this
            ->setGroup_Id($group_Id)
            ->setGroupName($groupName);
    }
    /**
     * Get Group_Id value
     * @return int
     */
    public function getGroup_Id()
    {
        return $this->Group_Id;
    }
    /**
     * Set Group_Id value
     * @param int $group_Id
     * @return \StructType\GetGroupsQuery
     */
    public function setGroup_Id($group_Id = null)
    {
        // validation for constraint: int
        if (!is_null($group_Id) && !is_numeric($group_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($group_Id)), __LINE__);
        }
        $this->Group_Id = $group_Id;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \StructType\GetGroupsQuery
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetGroupsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
