<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContactMergeLogsQuery StructType
 * @subpackage Structs
 */
class GetContactMergeLogsQuery extends DatePagingQuery
{
    /**
     * The SurvivingContact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SurvivingContact_Id;
    /**
     * The DeletedContact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DeletedContact_Id;
    /**
     * Constructor method for GetContactMergeLogsQuery
     * @uses GetContactMergeLogsQuery::setSurvivingContact_Id()
     * @uses GetContactMergeLogsQuery::setDeletedContact_Id()
     * @param int $survivingContact_Id
     * @param int $deletedContact_Id
     */
    public function __construct($survivingContact_Id = null, $deletedContact_Id = null)
    {
        $this
            ->setSurvivingContact_Id($survivingContact_Id)
            ->setDeletedContact_Id($deletedContact_Id);
    }
    /**
     * Get SurvivingContact_Id value
     * @return int
     */
    public function getSurvivingContact_Id()
    {
        return $this->SurvivingContact_Id;
    }
    /**
     * Set SurvivingContact_Id value
     * @param int $survivingContact_Id
     * @return \StructType\GetContactMergeLogsQuery
     */
    public function setSurvivingContact_Id($survivingContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($survivingContact_Id) && !is_numeric($survivingContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($survivingContact_Id)), __LINE__);
        }
        $this->SurvivingContact_Id = $survivingContact_Id;
        return $this;
    }
    /**
     * Get DeletedContact_Id value
     * @return int
     */
    public function getDeletedContact_Id()
    {
        return $this->DeletedContact_Id;
    }
    /**
     * Set DeletedContact_Id value
     * @param int $deletedContact_Id
     * @return \StructType\GetContactMergeLogsQuery
     */
    public function setDeletedContact_Id($deletedContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($deletedContact_Id) && !is_numeric($deletedContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deletedContact_Id)), __LINE__);
        }
        $this->DeletedContact_Id = $deletedContact_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetContactMergeLogsQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
