<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCasesQuery StructType
 * @subpackage Structs
 */
class GetCasesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Case_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Case_Id;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The AssignedToContact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AssignedToContact_Id;
    /**
     * The CaseName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CaseName;
    /**
     * The ContactEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmail;
    /**
     * Constructor method for GetCasesQuery
     * @uses GetCasesQuery::setCase_Id()
     * @uses GetCasesQuery::setStatus()
     * @uses GetCasesQuery::setContact_Id()
     * @uses GetCasesQuery::setAssignedToContact_Id()
     * @uses GetCasesQuery::setCaseName()
     * @uses GetCasesQuery::setContactEmail()
     * @param int $case_Id
     * @param string $status
     * @param int $contact_Id
     * @param int $assignedToContact_Id
     * @param string $caseName
     * @param string $contactEmail
     */
    public function __construct($case_Id = null, $status = null, $contact_Id = null, $assignedToContact_Id = null, $caseName = null, $contactEmail = null)
    {
        $this
            ->setCase_Id($case_Id)
            ->setStatus($status)
            ->setContact_Id($contact_Id)
            ->setAssignedToContact_Id($assignedToContact_Id)
            ->setCaseName($caseName)
            ->setContactEmail($contactEmail);
    }
    /**
     * Get Case_Id value
     * @return int
     */
    public function getCase_Id()
    {
        return $this->Case_Id;
    }
    /**
     * Set Case_Id value
     * @param int $case_Id
     * @return \StructType\GetCasesQuery
     */
    public function setCase_Id($case_Id = null)
    {
        // validation for constraint: int
        if (!is_null($case_Id) && !is_numeric($case_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($case_Id)), __LINE__);
        }
        $this->Case_Id = $case_Id;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\CaseStatuses::valueIsValid()
     * @uses \EnumType\CaseStatuses::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\GetCasesQuery
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CaseStatuses::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\CaseStatuses::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetCasesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get AssignedToContact_Id value
     * @return int
     */
    public function getAssignedToContact_Id()
    {
        return $this->AssignedToContact_Id;
    }
    /**
     * Set AssignedToContact_Id value
     * @param int $assignedToContact_Id
     * @return \StructType\GetCasesQuery
     */
    public function setAssignedToContact_Id($assignedToContact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($assignedToContact_Id) && !is_numeric($assignedToContact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignedToContact_Id)), __LINE__);
        }
        $this->AssignedToContact_Id = $assignedToContact_Id;
        return $this;
    }
    /**
     * Get CaseName value
     * @return string|null
     */
    public function getCaseName()
    {
        return $this->CaseName;
    }
    /**
     * Set CaseName value
     * @param string $caseName
     * @return \StructType\GetCasesQuery
     */
    public function setCaseName($caseName = null)
    {
        // validation for constraint: string
        if (!is_null($caseName) && !is_string($caseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caseName)), __LINE__);
        }
        $this->CaseName = $caseName;
        return $this;
    }
    /**
     * Get ContactEmail value
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->ContactEmail;
    }
    /**
     * Set ContactEmail value
     * @param string $contactEmail
     * @return \StructType\GetCasesQuery
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactEmail)), __LINE__);
        }
        $this->ContactEmail = $contactEmail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCasesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
