<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivitiesQuery StructType
 * @subpackage Structs
 */
class GetActivitiesQuery extends DateAdvancedPagingQuery
{
    /**
     * The Activity_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Activity_Id;
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * Constructor method for GetActivitiesQuery
     * @uses GetActivitiesQuery::setActivity_Id()
     * @uses GetActivitiesQuery::setContact_Id()
     * @param int $activity_Id
     * @param int $contact_Id
     */
    public function __construct($activity_Id = null, $contact_Id = null)
    {
        $this
            ->setActivity_Id($activity_Id)
            ->setContact_Id($contact_Id);
    }
    /**
     * Get Activity_Id value
     * @return int
     */
    public function getActivity_Id()
    {
        return $this->Activity_Id;
    }
    /**
     * Set Activity_Id value
     * @param int $activity_Id
     * @return \StructType\GetActivitiesQuery
     */
    public function setActivity_Id($activity_Id = null)
    {
        // validation for constraint: int
        if (!is_null($activity_Id) && !is_numeric($activity_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activity_Id)), __LINE__);
        }
        $this->Activity_Id = $activity_Id;
        return $this;
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GetActivitiesQuery
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetActivitiesQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
