<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateSustainerReactivationLinkParameters StructType
 * @subpackage Structs
 */
class GenerateSustainerReactivationLinkParameters extends AbstractStructBase
{
    /**
     * The Contact_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Contact_Id;
    /**
     * The Sustainer_Id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Sustainer_Id;
    /**
     * The AudienceSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FindOrCreateAudienceSegmentParameters
     */
    public $AudienceSegment;
    /**
     * Constructor method for GenerateSustainerReactivationLinkParameters
     * @uses GenerateSustainerReactivationLinkParameters::setContact_Id()
     * @uses GenerateSustainerReactivationLinkParameters::setSustainer_Id()
     * @uses GenerateSustainerReactivationLinkParameters::setAudienceSegment()
     * @param int $contact_Id
     * @param int $sustainer_Id
     * @param \StructType\FindOrCreateAudienceSegmentParameters $audienceSegment
     */
    public function __construct($contact_Id = null, $sustainer_Id = null, \StructType\FindOrCreateAudienceSegmentParameters $audienceSegment = null)
    {
        $this
            ->setContact_Id($contact_Id)
            ->setSustainer_Id($sustainer_Id)
            ->setAudienceSegment($audienceSegment);
    }
    /**
     * Get Contact_Id value
     * @return int
     */
    public function getContact_Id()
    {
        return $this->Contact_Id;
    }
    /**
     * Set Contact_Id value
     * @param int $contact_Id
     * @return \StructType\GenerateSustainerReactivationLinkParameters
     */
    public function setContact_Id($contact_Id = null)
    {
        // validation for constraint: int
        if (!is_null($contact_Id) && !is_numeric($contact_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contact_Id)), __LINE__);
        }
        $this->Contact_Id = $contact_Id;
        return $this;
    }
    /**
     * Get Sustainer_Id value
     * @return int
     */
    public function getSustainer_Id()
    {
        return $this->Sustainer_Id;
    }
    /**
     * Set Sustainer_Id value
     * @param int $sustainer_Id
     * @return \StructType\GenerateSustainerReactivationLinkParameters
     */
    public function setSustainer_Id($sustainer_Id = null)
    {
        // validation for constraint: int
        if (!is_null($sustainer_Id) && !is_numeric($sustainer_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sustainer_Id)), __LINE__);
        }
        $this->Sustainer_Id = $sustainer_Id;
        return $this;
    }
    /**
     * Get AudienceSegment value
     * @return \StructType\FindOrCreateAudienceSegmentParameters|null
     */
    public function getAudienceSegment()
    {
        return $this->AudienceSegment;
    }
    /**
     * Set AudienceSegment value
     * @param \StructType\FindOrCreateAudienceSegmentParameters $audienceSegment
     * @return \StructType\GenerateSustainerReactivationLinkParameters
     */
    public function setAudienceSegment(\StructType\FindOrCreateAudienceSegmentParameters $audienceSegment = null)
    {
        $this->AudienceSegment = $audienceSegment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenerateSustainerReactivationLinkParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
