<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventType StructType
 * @subpackage Structs
 */
class EventType extends LookupType
{
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Parent_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Parent_Id;
    /**
     * The HierarchyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HierarchyName;
    /**
     * Constructor method for EventType
     * @uses EventType::setIsActive()
     * @uses EventType::setParent_Id()
     * @uses EventType::setHierarchyName()
     * @param bool $isActive
     * @param int $parent_Id
     * @param string $hierarchyName
     */
    public function __construct($isActive = null, $parent_Id = null, $hierarchyName = null)
    {
        $this
            ->setIsActive($isActive)
            ->setParent_Id($parent_Id)
            ->setHierarchyName($hierarchyName);
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\EventType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Parent_Id value
     * @return int
     */
    public function getParent_Id()
    {
        return $this->Parent_Id;
    }
    /**
     * Set Parent_Id value
     * @param int $parent_Id
     * @return \StructType\EventType
     */
    public function setParent_Id($parent_Id = null)
    {
        // validation for constraint: int
        if (!is_null($parent_Id) && !is_numeric($parent_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parent_Id)), __LINE__);
        }
        $this->Parent_Id = $parent_Id;
        return $this;
    }
    /**
     * Get HierarchyName value
     * @return string|null
     */
    public function getHierarchyName()
    {
        return $this->HierarchyName;
    }
    /**
     * Set HierarchyName value
     * @param string $hierarchyName
     * @return \StructType\EventType
     */
    public function setHierarchyName($hierarchyName = null)
    {
        // validation for constraint: string
        if (!is_null($hierarchyName) && !is_string($hierarchyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hierarchyName)), __LINE__);
        }
        $this->HierarchyName = $hierarchyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
