<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRegistrationRecord StructType
 * @subpackage Structs
 */
class EventRegistrationRecord extends DataRecord
{
    /**
     * The Transaction_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Transaction_Id;
    /**
     * The HostRegistration_Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $HostRegistration_Id;
    /**
     * The CheckedIn
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $CheckedIn;
    /**
     * The Event
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EventDetail
     */
    public $Event;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactSummary
     */
    public $Contact;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TicketType
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegistrationStatus
     */
    public $Status;
    /**
     * The PaddleNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaddleNumber;
    /**
     * The JerseyNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JerseyNumber;
    /**
     * The DietaryRestrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DietaryRestrictions;
    /**
     * Constructor method for EventRegistrationRecord
     * @uses EventRegistrationRecord::setTransaction_Id()
     * @uses EventRegistrationRecord::setHostRegistration_Id()
     * @uses EventRegistrationRecord::setCheckedIn()
     * @uses EventRegistrationRecord::setEvent()
     * @uses EventRegistrationRecord::setContact()
     * @uses EventRegistrationRecord::setType()
     * @uses EventRegistrationRecord::setStatus()
     * @uses EventRegistrationRecord::setPaddleNumber()
     * @uses EventRegistrationRecord::setJerseyNumber()
     * @uses EventRegistrationRecord::setDietaryRestrictions()
     * @param int $transaction_Id
     * @param int $hostRegistration_Id
     * @param bool $checkedIn
     * @param \StructType\EventDetail $event
     * @param \StructType\ContactSummary $contact
     * @param \StructType\TicketType $type
     * @param \StructType\RegistrationStatus $status
     * @param string $paddleNumber
     * @param string $jerseyNumber
     * @param string $dietaryRestrictions
     */
    public function __construct($transaction_Id = null, $hostRegistration_Id = null, $checkedIn = null, \StructType\EventDetail $event = null, \StructType\ContactSummary $contact = null, \StructType\TicketType $type = null, \StructType\RegistrationStatus $status = null, $paddleNumber = null, $jerseyNumber = null, $dietaryRestrictions = null)
    {
        $this
            ->setTransaction_Id($transaction_Id)
            ->setHostRegistration_Id($hostRegistration_Id)
            ->setCheckedIn($checkedIn)
            ->setEvent($event)
            ->setContact($contact)
            ->setType($type)
            ->setStatus($status)
            ->setPaddleNumber($paddleNumber)
            ->setJerseyNumber($jerseyNumber)
            ->setDietaryRestrictions($dietaryRestrictions);
    }
    /**
     * Get Transaction_Id value
     * @return int
     */
    public function getTransaction_Id()
    {
        return $this->Transaction_Id;
    }
    /**
     * Set Transaction_Id value
     * @param int $transaction_Id
     * @return \StructType\EventRegistrationRecord
     */
    public function setTransaction_Id($transaction_Id = null)
    {
        // validation for constraint: int
        if (!is_null($transaction_Id) && !is_numeric($transaction_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction_Id)), __LINE__);
        }
        $this->Transaction_Id = $transaction_Id;
        return $this;
    }
    /**
     * Get HostRegistration_Id value
     * @return int
     */
    public function getHostRegistration_Id()
    {
        return $this->HostRegistration_Id;
    }
    /**
     * Set HostRegistration_Id value
     * @param int $hostRegistration_Id
     * @return \StructType\EventRegistrationRecord
     */
    public function setHostRegistration_Id($hostRegistration_Id = null)
    {
        // validation for constraint: int
        if (!is_null($hostRegistration_Id) && !is_numeric($hostRegistration_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hostRegistration_Id)), __LINE__);
        }
        $this->HostRegistration_Id = $hostRegistration_Id;
        return $this;
    }
    /**
     * Get CheckedIn value
     * @return bool
     */
    public function getCheckedIn()
    {
        return $this->CheckedIn;
    }
    /**
     * Set CheckedIn value
     * @param bool $checkedIn
     * @return \StructType\EventRegistrationRecord
     */
    public function setCheckedIn($checkedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkedIn) && !is_bool($checkedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkedIn)), __LINE__);
        }
        $this->CheckedIn = $checkedIn;
        return $this;
    }
    /**
     * Get Event value
     * @return \StructType\EventDetail|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param \StructType\EventDetail $event
     * @return \StructType\EventRegistrationRecord
     */
    public function setEvent(\StructType\EventDetail $event = null)
    {
        $this->Event = $event;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactSummary|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \StructType\ContactSummary $contact
     * @return \StructType\EventRegistrationRecord
     */
    public function setContact(\StructType\ContactSummary $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\TicketType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\TicketType $type
     * @return \StructType\EventRegistrationRecord
     */
    public function setType(\StructType\TicketType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\RegistrationStatus|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\RegistrationStatus $status
     * @return \StructType\EventRegistrationRecord
     */
    public function setStatus(\StructType\RegistrationStatus $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaddleNumber value
     * @return string|null
     */
    public function getPaddleNumber()
    {
        return $this->PaddleNumber;
    }
    /**
     * Set PaddleNumber value
     * @param string $paddleNumber
     * @return \StructType\EventRegistrationRecord
     */
    public function setPaddleNumber($paddleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paddleNumber) && !is_string($paddleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paddleNumber)), __LINE__);
        }
        $this->PaddleNumber = $paddleNumber;
        return $this;
    }
    /**
     * Get JerseyNumber value
     * @return string|null
     */
    public function getJerseyNumber()
    {
        return $this->JerseyNumber;
    }
    /**
     * Set JerseyNumber value
     * @param string $jerseyNumber
     * @return \StructType\EventRegistrationRecord
     */
    public function setJerseyNumber($jerseyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($jerseyNumber) && !is_string($jerseyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jerseyNumber)), __LINE__);
        }
        $this->JerseyNumber = $jerseyNumber;
        return $this;
    }
    /**
     * Get DietaryRestrictions value
     * @return string|null
     */
    public function getDietaryRestrictions()
    {
        return $this->DietaryRestrictions;
    }
    /**
     * Set DietaryRestrictions value
     * @param string $dietaryRestrictions
     * @return \StructType\EventRegistrationRecord
     */
    public function setDietaryRestrictions($dietaryRestrictions = null)
    {
        // validation for constraint: string
        if (!is_null($dietaryRestrictions) && !is_string($dietaryRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dietaryRestrictions)), __LINE__);
        }
        $this->DietaryRestrictions = $dietaryRestrictions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EventRegistrationRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
